/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.message;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.InflaterInputStream;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.transport.amqp.message.AmqpContentTypeSupport;
import org.apache.activemq.transport.amqp.message.InvalidContentTypeException;
import org.apache.activemq.util.ByteArrayInputStream;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.JMSExceptionSupport;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.message.Message;

public final class AmqpMessageSupport {
    public static final String JMS_AMQP_PREFIX = "JMS_AMQP_";
    public static final int JMS_AMQP_PREFIX_LENGTH;
    public static final String MESSAGE_FORMAT = "MESSAGE_FORMAT";
    public static final String ORIGINAL_ENCODING = "ORIGINAL_ENCODING";
    public static final String NATIVE = "NATIVE";
    public static final String HEADER = "HEADER";
    public static final String PROPERTIES = "PROPERTIES";
    public static final String FIRST_ACQUIRER = "FirstAcquirer";
    public static final String CONTENT_TYPE = "ContentType";
    public static final String CONTENT_ENCODING = "ContentEncoding";
    public static final String REPLYTO_GROUP_ID = "ReplyToGroupID";
    public static final String DELIVERY_ANNOTATION_PREFIX = "DA_";
    public static final String MESSAGE_ANNOTATION_PREFIX = "MA_";
    public static final String FOOTER_PREFIX = "FT_";
    public static final String JMS_AMQP_HEADER = "JMS_AMQP_HEADER";
    public static final String JMS_AMQP_PROPERTIES = "JMS_AMQP_PROPERTIES";
    public static final String JMS_AMQP_ORIGINAL_ENCODING = "JMS_AMQP_ORIGINAL_ENCODING";
    public static final String JMS_AMQP_MESSAGE_FORMAT = "JMS_AMQP_MESSAGE_FORMAT";
    public static final String JMS_AMQP_NATIVE = "JMS_AMQP_NATIVE";
    public static final String JMS_AMQP_FIRST_ACQUIRER = "JMS_AMQP_FirstAcquirer";
    public static final String JMS_AMQP_CONTENT_TYPE = "JMS_AMQP_ContentType";
    public static final String JMS_AMQP_CONTENT_ENCODING = "JMS_AMQP_ContentEncoding";
    public static final String JMS_AMQP_REPLYTO_GROUP_ID = "JMS_AMQP_ReplyToGroupID";
    public static final String JMS_AMQP_DELIVERY_ANNOTATION_PREFIX = "JMS_AMQP_DA_";
    public static final String JMS_AMQP_MESSAGE_ANNOTATION_PREFIX = "JMS_AMQP_MA_";
    public static final String JMS_AMQP_FOOTER_PREFIX = "JMS_AMQP_FT_";
    public static final Binary EMPTY_BINARY;
    public static final Data EMPTY_BODY;
    public static final Data NULL_OBJECT_BODY;
    public static final short AMQP_UNKNOWN = 0;
    public static final short AMQP_NULL = 1;
    public static final short AMQP_DATA = 2;
    public static final short AMQP_SEQUENCE = 3;
    public static final short AMQP_VALUE_NULL = 4;
    public static final short AMQP_VALUE_STRING = 5;
    public static final short AMQP_VALUE_BINARY = 6;
    public static final short AMQP_VALUE_MAP = 7;
    public static final short AMQP_VALUE_LIST = 8;
    public static final String SERIALIZED_JAVA_OBJECT_CONTENT_TYPE = "application/x-java-serialized-object";
    public static final String OCTET_STREAM_CONTENT_TYPE = "application/octet-stream";

    public static Symbol getSymbol(String key) {
        return Symbol.valueOf((String)key);
    }

    public static Object getMessageAnnotation(String key, Message message) {
        if (message != null && message.getMessageAnnotations() != null) {
            Map annotations = message.getMessageAnnotations().getValue();
            return annotations.get(AmqpMessageSupport.getSymbol(key));
        }
        return null;
    }

    public static boolean isContentType(String contentType, Message message) {
        if (contentType == null) {
            return message.getContentType() == null;
        }
        return contentType.equals(message.getContentType());
    }

    public static Charset getCharsetForTextualContent(String contentType) {
        try {
            return AmqpContentTypeSupport.parseContentTypeForTextualCharset(contentType);
        }
        catch (InvalidContentTypeException e) {
            return null;
        }
    }

    private static byte[] getSerializedBytes(Serializable value) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(value);
                oos.flush();
                oos.close();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public static Binary getBinaryFromMessageBody(ActiveMQBytesMessage message) throws JMSException {
        Binary result = null;
        if (message.getContent() != null) {
            ByteSequence contents = message.getContent();
            if (message.isCompressed()) {
                int length = (int)message.getBodyLength();
                byte[] uncompressed = new byte[length];
                message.readBytes(uncompressed);
                result = new Binary(uncompressed);
            } else {
                return new Binary(contents.getData(), contents.getOffset(), contents.getLength());
            }
        }
        return result;
    }

    public static Binary getBinaryFromMessageBody(ActiveMQObjectMessage message) throws JMSException {
        Binary result;
        block20: {
            result = null;
            if (message.getContent() != null) {
                ByteSequence contents = message.getContent();
                if (message.isCompressed()) {
                    try (ByteArrayOutputStream os = new ByteArrayOutputStream();
                         ByteArrayInputStream is = new ByteArrayInputStream(contents);
                         InflaterInputStream iis = new InflaterInputStream(is);){
                        byte value;
                        while ((value = (byte)iis.read()) != -1) {
                            os.write(value);
                        }
                        ByteSequence expanded = os.toByteSequence();
                        result = new Binary(expanded.getData(), expanded.getOffset(), expanded.getLength());
                        break block20;
                    }
                    catch (Exception cause) {
                        throw JMSExceptionSupport.create(cause);
                    }
                }
                return new Binary(contents.getData(), contents.getOffset(), contents.getLength());
            }
        }
        return result;
    }

    public static Binary getBinaryFromMessageBody(ActiveMQTextMessage message) throws JMSException {
        Binary result;
        block21: {
            result = null;
            if (message.getContent() != null) {
                ByteSequence contents = message.getContent();
                if (message.isCompressed()) {
                    try (ByteArrayInputStream is = new ByteArrayInputStream(contents);
                         InflaterInputStream iis = new InflaterInputStream(is);
                         DataInputStream dis = new DataInputStream(iis);){
                        int size = dis.readInt();
                        byte[] uncompressed = new byte[size];
                        dis.readFully(uncompressed);
                        result = new Binary(uncompressed);
                        break block21;
                    }
                    catch (Exception cause) {
                        throw JMSExceptionSupport.create(cause);
                    }
                }
                result = new Binary(contents.getData(), contents.getOffset() + 4, contents.getLength() - 4);
            } else if (message.getText() != null) {
                result = new Binary(message.getText().getBytes(StandardCharsets.UTF_8));
            }
        }
        return result;
    }

    public static Map<String, Object> getMapFromMessageBody(ActiveMQMapMessage message) throws JMSException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Map<String, Object> contentMap = message.getContentMap();
        if (contentMap != null) {
            for (Map.Entry<String, Object> entry : contentMap.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof byte[]) {
                    value = new Binary((byte[])value);
                }
                map.put(entry.getKey(), value);
            }
        }
        return map;
    }

    static {
        byte[] bytes;
        JMS_AMQP_PREFIX_LENGTH = JMS_AMQP_PREFIX.length();
        EMPTY_BINARY = new Binary(new byte[0]);
        EMPTY_BODY = new Data(EMPTY_BINARY);
        try {
            bytes = AmqpMessageSupport.getSerializedBytes(null);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialise null object body", e);
        }
        NULL_OBJECT_BODY = new Data(new Binary(bytes));
    }
}

