/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubscriptionOption;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.postoffice.Address;
import org.apache.activemq.artemis.core.postoffice.impl.AddressImpl;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTBundle;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTMessageInfo;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSession;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTSessionState {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final MQTTSessionState DEFAULT = new MQTTSessionState((String)null);
    private MQTTSession session;
    private final String clientId;
    private final ConcurrentMap<String, SubscriptionItem> subscriptions = new ConcurrentHashMap<String, SubscriptionItem>();
    private final Map<Integer, MQTTMessageInfo> messageRefStore = new ConcurrentHashMap<Integer, MQTTMessageInfo>();
    private final ConcurrentMap<String, Map<Long, Integer>> addressMessageMap = new ConcurrentHashMap<String, Map<Long, Integer>>();
    private final Set<Integer> pubRec = new HashSet<Integer>();
    private boolean attached = false;
    private long disconnectedTime = 0L;
    private final OutboundStore outboundStore = new OutboundStore();
    private int clientSessionExpiryInterval;
    private boolean isWill = false;
    private ByteBuf willMessage;
    private String willTopic;
    private int willQoSLevel;
    private boolean willRetain = false;
    private long willDelayInterval = 0L;
    private List<? extends MqttProperties.MqttProperty> willUserProperties;
    private WillStatus willStatus = WillStatus.NOT_SENT;
    private boolean failed = false;
    private int clientMaxPacketSize = 0;
    private Map<Integer, String> clientTopicAliases;
    private Integer clientTopicAliasMaximum;
    private Map<String, Integer> serverTopicAliases;

    public MQTTSessionState(String clientId) {
        this.clientId = clientId;
    }

    public MQTTSessionState(CoreMessage message) {
        logger.debug("Deserializing MQTT subscriptions from {}", (Object)message);
        this.clientId = message.getStringProperty(Message.HDR_LAST_VALUE_NAME);
        ActiveMQBuffer buf = message.getDataBuffer();
        byte version = buf.readByte();
        int subscriptionCount = buf.readInt();
        logger.debug("Deserializing {} subscriptions", (Object)subscriptionCount);
        for (int i = 0; i < subscriptionCount; ++i) {
            String topicName = buf.readString();
            MqttQoS qos = MqttQoS.valueOf((int)buf.readInt());
            boolean nolocal = buf.readBoolean();
            boolean retainAsPublished = buf.readBoolean();
            MqttSubscriptionOption.RetainedHandlingPolicy retainedHandlingPolicy = MqttSubscriptionOption.RetainedHandlingPolicy.valueOf((int)buf.readInt());
            Integer subscriptionId = buf.readNullableInt();
            this.subscriptions.put(topicName, new SubscriptionItem(new MqttTopicSubscription(topicName, new MqttSubscriptionOption(qos, nolocal, retainAsPublished, retainedHandlingPolicy)), subscriptionId));
        }
    }

    public MQTTSession getSession() {
        return this.session;
    }

    public void setSession(MQTTSession session) {
        this.session = session;
    }

    public synchronized void clear() throws Exception {
        this.subscriptions.clear();
        this.messageRefStore.clear();
        this.addressMessageMap.clear();
        this.pubRec.clear();
        this.outboundStore.clear();
        this.disconnectedTime = 0L;
        if (this.willMessage != null) {
            this.willMessage.clear();
            this.willMessage = null;
        }
        this.willStatus = WillStatus.NOT_SENT;
        this.failed = false;
        this.willDelayInterval = 0L;
        this.willRetain = false;
        this.willTopic = null;
        this.clientMaxPacketSize = 0;
        this.clearTopicAliases();
        this.clientTopicAliasMaximum = 0;
    }

    public OutboundStore getOutboundStore() {
        return this.outboundStore;
    }

    public Set<Integer> getPubRec() {
        return this.pubRec;
    }

    public boolean isAttached() {
        return this.attached;
    }

    public void setAttached(boolean attached) {
        this.attached = attached;
    }

    public Collection<MqttTopicSubscription> getSubscriptions() {
        HashSet<MqttTopicSubscription> result = new HashSet<MqttTopicSubscription>();
        for (SubscriptionItem item : this.subscriptions.values()) {
            result.add(item.getSubscription());
        }
        return result;
    }

    public Map<String, SubscriptionItem> getSubscriptionsPlusID() {
        return new HashMap<String, SubscriptionItem>(this.subscriptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSubscription(MqttTopicSubscription subscription, WildcardConfiguration wildcardConfiguration, Integer subscriptionIdentifier) throws Exception {
        ConcurrentMap<String, SubscriptionItem> concurrentMap = this.subscriptions;
        synchronized (concurrentMap) {
            this.addressMessageMap.putIfAbsent(MQTTUtil.getCoreAddressFromMqttTopic(subscription.topicFilter(), wildcardConfiguration), new ConcurrentHashMap());
            SubscriptionItem existingSubscription = (SubscriptionItem)this.subscriptions.get(subscription.topicFilter());
            if (existingSubscription != null) {
                if (subscription.qualityOfService().value() > existingSubscription.getSubscription().qualityOfService().value() || !Objects.equals(subscriptionIdentifier, existingSubscription.getId())) {
                    existingSubscription.update(subscription, subscriptionIdentifier);
                    return true;
                }
                return false;
            }
            this.subscriptions.put(subscription.topicFilter(), new SubscriptionItem(subscription, subscriptionIdentifier));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscription(String address) throws Exception {
        ConcurrentMap<String, SubscriptionItem> concurrentMap = this.subscriptions;
        synchronized (concurrentMap) {
            this.subscriptions.remove(address);
            this.addressMessageMap.remove(address);
        }
    }

    public MqttTopicSubscription getSubscription(String address) {
        return this.subscriptions.get(address) != null ? ((SubscriptionItem)this.subscriptions.get(address)).getSubscription() : null;
    }

    public SubscriptionItem getSubscriptionPlusID(String address) {
        return (SubscriptionItem)this.subscriptions.get(address);
    }

    public List<Integer> getMatchingSubscriptionIdentifiers(String address) {
        String topic = MQTTUtil.getMqttTopicFromCoreAddress(address, this.session.getServer().getConfiguration().getWildcardConfiguration());
        ArrayList<Integer> result = null;
        for (SubscriptionItem item : this.subscriptions.values()) {
            Integer matchingId = item.getMatchingId(topic);
            if (matchingId == null) continue;
            if (result == null) {
                result = new ArrayList<Integer>();
            }
            result.add(matchingId);
        }
        return result;
    }

    public String getClientId() {
        return this.clientId;
    }

    public long getDisconnectedTime() {
        return this.disconnectedTime;
    }

    public void setDisconnectedTime(long disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
    }

    public int getClientSessionExpiryInterval() {
        return this.clientSessionExpiryInterval;
    }

    public void setClientSessionExpiryInterval(int sessionExpiryInterval) {
        this.clientSessionExpiryInterval = sessionExpiryInterval;
    }

    public boolean isWill() {
        return this.isWill;
    }

    public void setWill(boolean will) {
        this.isWill = will;
    }

    public ByteBuf getWillMessage() {
        return this.willMessage;
    }

    public void setWillMessage(ByteBuf willMessage) {
        this.willMessage = willMessage;
    }

    public String getWillTopic() {
        return this.willTopic;
    }

    public void setWillTopic(String willTopic) {
        this.willTopic = willTopic;
    }

    public int getWillQoSLevel() {
        return this.willQoSLevel;
    }

    public void setWillQoSLevel(int willQoSLevel) {
        this.willQoSLevel = willQoSLevel;
    }

    public boolean isWillRetain() {
        return this.willRetain;
    }

    public void setWillRetain(boolean willRetain) {
        this.willRetain = willRetain;
    }

    public long getWillDelayInterval() {
        return this.willDelayInterval;
    }

    public void setWillDelayInterval(long willDelayInterval) {
        this.willDelayInterval = willDelayInterval;
    }

    public void setWillUserProperties(List<? extends MqttProperties.MqttProperty> userProperties) {
        this.willUserProperties = userProperties;
    }

    public List<? extends MqttProperties.MqttProperty> getWillUserProperties() {
        return this.willUserProperties;
    }

    public WillStatus getWillStatus() {
        return this.willStatus;
    }

    public void setWillStatus(WillStatus willStatus) {
        this.willStatus = willStatus;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public int getClientMaxPacketSize() {
        return this.clientMaxPacketSize;
    }

    public void setClientMaxPacketSize(int clientMaxPacketSize) {
        this.clientMaxPacketSize = clientMaxPacketSize;
    }

    public void putClientTopicAlias(Integer alias, String topicName) {
        if (this.clientTopicAliases == null) {
            this.clientTopicAliases = new HashMap<Integer, String>();
        }
        this.clientTopicAliases.put(alias, topicName);
    }

    public String getClientTopicAlias(Integer alias) {
        String result = this.clientTopicAliases == null ? null : this.clientTopicAliases.get(alias);
        return result;
    }

    public Integer getClientTopicAliasMaximum() {
        return this.clientTopicAliasMaximum;
    }

    public void setClientTopicAliasMaximum(Integer clientTopicAliasMaximum) {
        this.clientTopicAliasMaximum = clientTopicAliasMaximum;
    }

    public Integer addServerTopicAlias(String topicName) {
        Integer alias;
        if (this.serverTopicAliases == null) {
            this.serverTopicAliases = new ConcurrentHashMap<String, Integer>();
        }
        if ((alias = Integer.valueOf(this.serverTopicAliases.size() + 1)) <= this.clientTopicAliasMaximum) {
            this.serverTopicAliases.put(topicName, alias);
            return alias;
        }
        return null;
    }

    public Integer getServerTopicAlias(String topicName) {
        return this.serverTopicAliases == null ? null : this.serverTopicAliases.get(topicName);
    }

    void removeMessageRef(Integer mqttId) {
        Map addressMap;
        MQTTMessageInfo info = this.messageRefStore.remove(mqttId);
        if (info != null && (addressMap = (Map)this.addressMessageMap.get(info.getAddress())) != null) {
            addressMap.remove(info.getServerMessageId());
        }
    }

    public void clearTopicAliases() {
        if (this.clientTopicAliases != null) {
            this.clientTopicAliases.clear();
            this.clientTopicAliases = null;
        }
        if (this.serverTopicAliases != null) {
            this.serverTopicAliases.clear();
            this.serverTopicAliases = null;
        }
    }

    public String toString() {
        return "MQTTSessionState[session=" + String.valueOf(this.session) + ", clientId=" + this.clientId + ", subscriptions=" + String.valueOf(this.subscriptions) + ", messageRefStore=" + String.valueOf(this.messageRefStore) + ", addressMessageMap=" + String.valueOf(this.addressMessageMap) + ", pubRec=" + String.valueOf(this.pubRec) + ", attached=" + this.attached + ", outboundStore=" + String.valueOf(this.outboundStore) + ", disconnectedTime=" + this.disconnectedTime + ", sessionExpiryInterval=" + this.clientSessionExpiryInterval + ", isWill=" + this.isWill + ", willMessage=" + String.valueOf(this.willMessage) + ", willTopic=" + this.willTopic + ", willQoSLevel=" + this.willQoSLevel + ", willRetain=" + this.willRetain + ", willDelayInterval=" + this.willDelayInterval + ", failed=" + this.failed + ", maxPacketSize=" + this.clientMaxPacketSize + "]@" + System.identityHashCode(this);
    }

    public static class OutboundStore {
        private final Map<Pair<Long, Long>, Integer> artemisToMqttMessageMap = new HashMap<Pair<Long, Long>, Integer>();
        private final Map<Integer, Pair<Long, Long>> mqttToServerIds = new HashMap<Integer, Pair<Long, Long>>();
        private final Object dataStoreLock = new Object();
        private static final int INITIAL_ID = 0;
        private int currentId = 0;
        private int sendQuota = 0;

        private Pair<Long, Long> generateKey(long messageId, long consumerID) {
            return new Pair((Object)messageId, (Object)consumerID);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int generateMqttId(long messageId, long consumerId) {
            Object object = this.dataStoreLock;
            synchronized (object) {
                Integer id = this.artemisToMqttMessageMap.get(this.generateKey(messageId, consumerId));
                if (id == null) {
                    int start = this.currentId;
                    do {
                        if (++this.currentId > MQTTUtil.TWO_BYTE_INT_MAX) {
                            this.currentId = 0;
                        }
                        if (start != this.currentId) continue;
                        if (this.currentId != 0 && !this.mqttToServerIds.containsKey(this.currentId)) break;
                        throw MQTTBundle.BUNDLE.unableToGenerateID();
                    } while (this.mqttToServerIds.containsKey(this.currentId) || this.currentId == 0);
                    id = this.currentId;
                }
                return id;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void publish(int mqtt, long messageId, long consumerId) {
            Object object = this.dataStoreLock;
            synchronized (object) {
                Pair<Long, Long> key = this.generateKey(messageId, consumerId);
                this.artemisToMqttMessageMap.put(key, mqtt);
                this.mqttToServerIds.put(mqtt, key);
                ++this.sendQuota;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Pair<Long, Long> publishAckd(int mqtt) {
            Object object = this.dataStoreLock;
            synchronized (object) {
                Pair<Long, Long> p = this.mqttToServerIds.remove(mqtt);
                if (p != null) {
                    --this.sendQuota;
                    this.artemisToMqttMessageMap.remove(p);
                }
                return p;
            }
        }

        public Pair<Long, Long> publishReceived(int mqtt) {
            return this.publishAckd(mqtt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void publishReleasedSent(int mqttId, long serverMessageId) {
            Object object = this.dataStoreLock;
            synchronized (object) {
                this.mqttToServerIds.put(mqttId, (Pair<Long, Long>)new Pair((Object)serverMessageId, (Object)0L));
                ++this.sendQuota;
            }
        }

        public Pair<Long, Long> publishComplete(int mqtt) {
            return this.publishAckd(mqtt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.dataStoreLock;
            synchronized (object) {
                this.artemisToMqttMessageMap.clear();
                this.mqttToServerIds.clear();
                this.currentId = 0;
                this.sendQuota = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getSendQuota() {
            Object object = this.dataStoreLock;
            synchronized (object) {
                return this.sendQuota;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetSendQuota() {
            Object object = this.dataStoreLock;
            synchronized (object) {
                this.sendQuota = 0;
            }
        }
    }

    public static enum WillStatus {
        NOT_SENT,
        SENT,
        SENDING;


        public byte getStatus() {
            return switch (this.ordinal()) {
                case 0 -> 0;
                case 1 -> 1;
                case 2 -> 2;
                default -> -1;
            };
        }

        public static WillStatus getStatus(byte status) {
            return switch (status) {
                case 0 -> NOT_SENT;
                case 1 -> SENT;
                case 2 -> SENDING;
                default -> null;
            };
        }
    }

    public static class SubscriptionItem {
        private MqttTopicSubscription subscription;
        private Integer id;
        private Address address;

        public SubscriptionItem(MqttTopicSubscription subscription, Integer id) {
            this.update(subscription, id);
        }

        public MqttTopicSubscription getSubscription() {
            return this.subscription;
        }

        public Integer getId() {
            return this.id;
        }

        public Integer getMatchingId(String topic) {
            if (this.id != null && new AddressImpl(SimpleString.of((String)topic), MQTTUtil.MQTT_WILDCARD).matches(this.address)) {
                return this.id;
            }
            return null;
        }

        private void update(MqttTopicSubscription newSub, Integer newId) {
            if (!(newId == null || newId.equals(this.id) || this.address != null && this.subscription.topicFilter().equals(newSub.topicFilter()))) {
                this.address = new AddressImpl(SimpleString.of((String)newSub.topicFilter()), MQTTUtil.MQTT_WILDCARD);
            }
            this.subscription = newSub;
            this.id = newId;
        }
    }
}

