/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.codegentest;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.avro.Conversion;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.apache.avro.codegentest.FixedSizeString;
import org.apache.avro.codegentest.FixedSizeStringLogicalType;

public class FixedSizeStringConversion
extends Conversion<FixedSizeString> {
    public Class<FixedSizeString> getConvertedType() {
        return FixedSizeString.class;
    }

    public String getLogicalTypeName() {
        return "fixed-size-string";
    }

    public FixedSizeString fromBytes(ByteBuffer value, Schema schema, LogicalType type) {
        String stringValue = StandardCharsets.UTF_8.decode(value).toString();
        this.validate(stringValue, type);
        return new FixedSizeString(stringValue);
    }

    public ByteBuffer toBytes(FixedSizeString value, Schema schema, LogicalType type) {
        this.validate(value.getValue(), type);
        return StandardCharsets.UTF_8.encode(value.getValue());
    }

    private void validate(String value, LogicalType logicalType) {
        FixedSizeStringLogicalType fixedSizeStringLogicalType = (FixedSizeStringLogicalType)logicalType;
        int minValue = fixedSizeStringLogicalType.getMinLength();
        int maxValue = fixedSizeStringLogicalType.getMaxLength();
        if (Objects.nonNull(value) && (value.length() < minValue || value.length() > maxValue)) {
            throw new IllegalArgumentException(String.format("Incorrect size. Must satisfy %d <= value <= %d", minValue, maxValue));
        }
    }
}

