/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	context "context"

	camelv1 "github.com/apache/camel-k/v2/pkg/apis/camel/v1"
	applyconfigurationcamelv1 "github.com/apache/camel-k/v2/pkg/client/camel/applyconfiguration/camel/v1"
	scheme "github.com/apache/camel-k/v2/pkg/client/camel/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// IntegrationPlatformsGetter has a method to return a IntegrationPlatformInterface.
// A group's client should implement this interface.
type IntegrationPlatformsGetter interface {
	IntegrationPlatforms(namespace string) IntegrationPlatformInterface
}

// IntegrationPlatformInterface has methods to work with IntegrationPlatform resources.
type IntegrationPlatformInterface interface {
	Create(ctx context.Context, integrationPlatform *camelv1.IntegrationPlatform, opts metav1.CreateOptions) (*camelv1.IntegrationPlatform, error)
	Update(ctx context.Context, integrationPlatform *camelv1.IntegrationPlatform, opts metav1.UpdateOptions) (*camelv1.IntegrationPlatform, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, integrationPlatform *camelv1.IntegrationPlatform, opts metav1.UpdateOptions) (*camelv1.IntegrationPlatform, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*camelv1.IntegrationPlatform, error)
	List(ctx context.Context, opts metav1.ListOptions) (*camelv1.IntegrationPlatformList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *camelv1.IntegrationPlatform, err error)
	Apply(ctx context.Context, integrationPlatform *applyconfigurationcamelv1.IntegrationPlatformApplyConfiguration, opts metav1.ApplyOptions) (result *camelv1.IntegrationPlatform, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, integrationPlatform *applyconfigurationcamelv1.IntegrationPlatformApplyConfiguration, opts metav1.ApplyOptions) (result *camelv1.IntegrationPlatform, err error)
	IntegrationPlatformExpansion
}

// integrationPlatforms implements IntegrationPlatformInterface
type integrationPlatforms struct {
	*gentype.ClientWithListAndApply[*camelv1.IntegrationPlatform, *camelv1.IntegrationPlatformList, *applyconfigurationcamelv1.IntegrationPlatformApplyConfiguration]
}

// newIntegrationPlatforms returns a IntegrationPlatforms
func newIntegrationPlatforms(c *CamelV1Client, namespace string) *integrationPlatforms {
	return &integrationPlatforms{
		gentype.NewClientWithListAndApply[*camelv1.IntegrationPlatform, *camelv1.IntegrationPlatformList, *applyconfigurationcamelv1.IntegrationPlatformApplyConfiguration](
			"integrationplatforms",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *camelv1.IntegrationPlatform { return &camelv1.IntegrationPlatform{} },
			func() *camelv1.IntegrationPlatformList { return &camelv1.IntegrationPlatformList{} },
		),
	}
}
