/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.Version;

public final class VersionAndType {
    private static final Splitter splitOnDash = Splitter.on('-').omitEmptyStrings().trimResults();
    private final Version version;
    private final SSTableFormat.Type formatType;

    public VersionAndType(Version version, SSTableFormat.Type formatType) {
        this.version = version;
        this.formatType = formatType;
    }

    public Version version() {
        return this.version;
    }

    public SSTableFormat.Type formatType() {
        return this.formatType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionAndType that = (VersionAndType)o;
        return Objects.equals(this.version, that.version) && this.formatType == that.formatType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.formatType});
    }

    public static VersionAndType fromString(String versionAndType) {
        List<String> components = splitOnDash.splitToList(versionAndType);
        if (components.size() != 2) {
            throw new IllegalArgumentException("Invalid VersionAndType string: " + versionAndType + " (should be of the form 'big-bc')");
        }
        SSTableFormat.Type formatType = SSTableFormat.Type.validate(components.get(0));
        Version version = formatType.info.getVersion(components.get(1));
        return new VersionAndType(version, formatType);
    }

    public String toString() {
        return this.formatType.name + '-' + this.version;
    }
}

