/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.parser.jstack;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import org.gridkit.jvmtool.codec.stacktrace.ThreadSnapshotEvent;
import org.gridkit.jvmtool.event.Event;
import org.gridkit.jvmtool.event.EventDumpParser;
import org.gridkit.jvmtool.event.EventMorpher;
import org.gridkit.jvmtool.event.EventReader;
import org.gridkit.jvmtool.event.MorphingEventReader;
import org.gridkit.jvmtool.parser.jstack.JStackDumpParser;

public class JStackThreadDumpLoader
implements EventDumpParser {
    @Override
    public boolean isFunctional() {
        return true;
    }

    @Override
    public EventReader<Event> open(EventDumpParser.InputStreamSource source) throws IOException {
        InputStream is = source.open();
        InputStreamReader reader = new InputStreamReader(is);
        JStackDumpParser parser = new JStackDumpParser(reader);
        try {
            is.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (parser.isValid()) {
            List<ThreadSnapshotEvent> list = parser.getThreads();
            Iterator<Event> it = this.iterator(list);
            return new DumpReader(it).morph(new EventMorpher<Event, Event>(){

                @Override
                public Event morph(Event event) {
                    return event;
                }
            });
        }
        return null;
    }

    private Iterator<Event> iterator(List<ThreadSnapshotEvent> list) {
        return list.iterator();
    }

    public String toString() {
        return "JStack dump parser";
    }

    private static final class DumpReader
    implements EventReader<Event> {
        private final Iterator<Event> it;

        private DumpReader(Iterator<Event> it) {
            this.it = it;
        }

        @Override
        public Iterator<Event> iterator() {
            return this.it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Event next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <M extends Event> EventReader<M> morph(EventMorpher<Event, M> morpher) {
            return MorphingEventReader.morph(this, morpher);
        }

        @Override
        public Event peekNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void dispose() {
        }
    }
}

