/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.concurrent.Callable;
import org.apache.cassandra.concurrent.ExecutionFailure;
import org.apache.cassandra.utils.Closeable;
import org.apache.cassandra.utils.WithResources;
import org.apache.cassandra.utils.concurrent.RunnableFuture;
import org.apache.cassandra.utils.concurrent.SyncFuture;

public class SyncFutureTask<T>
extends SyncFuture<T>
implements RunnableFuture<T> {
    final Callable<T> call;

    public SyncFutureTask(Callable<T> call) {
        this.call = call;
    }

    public SyncFutureTask(final WithResources withResources, final Callable<T> call) {
        this.call = new Callable<T>(){

            @Override
            public T call() throws Exception {
                try (Closeable close = withResources.get();){
                    Object v = call.call();
                    return v;
                }
            }

            public String toString() {
                return call.toString();
            }
        };
    }

    @Override
    public void run() {
        try {
            if (!this.setUncancellable()) {
                if (this.isCancelled()) {
                    return;
                }
                throw new IllegalStateException();
            }
            if (!this.trySuccess(this.call.call())) {
                throw new IllegalStateException();
            }
        }
        catch (Throwable t2) {
            this.tryFailure(t2);
            ExecutionFailure.handle(t2);
        }
    }

    @Override
    public String description() {
        return this.call.toString();
    }
}

