/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.OptionalInt;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.KeyReader;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.CompressionInfoComponent;
import org.apache.cassandra.io.sstable.format.FilterComponent;
import org.apache.cassandra.io.sstable.format.IndexComponent;
import org.apache.cassandra.io.sstable.format.SortedTableReaderLoadingBuilder;
import org.apache.cassandra.io.sstable.format.StatsComponent;
import org.apache.cassandra.io.sstable.format.big.BigFormat;
import org.apache.cassandra.io.sstable.format.big.BigTableKeyReader;
import org.apache.cassandra.io.sstable.format.big.BigTableReader;
import org.apache.cassandra.io.sstable.format.big.IndexSummaryComponent;
import org.apache.cassandra.io.sstable.format.big.RowIndexEntry;
import org.apache.cassandra.io.sstable.indexsummary.IndexSummary;
import org.apache.cassandra.io.sstable.indexsummary.IndexSummaryBuilder;
import org.apache.cassandra.io.sstable.keycache.KeyCache;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.ValidationMetadata;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FilterFactory;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigSSTableReaderLoadingBuilder
extends SortedTableReaderLoadingBuilder<BigTableReader, BigTableReader.Builder> {
    private static final Logger logger = LoggerFactory.getLogger(BigSSTableReaderLoadingBuilder.class);
    private FileHandle.Builder indexFileBuilder;

    public BigSSTableReaderLoadingBuilder(SSTable.Builder<?, ?> descriptor) {
        super(descriptor);
    }

    @Override
    protected void openComponents(BigTableReader.Builder builder, SSTable.Owner owner, boolean validate, boolean online) throws IOException {
        try {
            boolean rebuildSummary;
            IndexSummaryComponent summaryComponent;
            if (online && builder.getTableMetadataRef().getLocal().params.caching.cacheKeys()) {
                builder.setKeyCache(new KeyCache(CacheService.instance.keyCache));
            }
            StatsComponent statsComponent = StatsComponent.load(this.descriptor, MetadataType.STATS, MetadataType.HEADER, MetadataType.VALIDATION);
            builder.setSerializationHeader(statsComponent.serializationHeader(builder.getTableMetadataRef().getLocal()));
            Preconditions.checkArgument(!online || builder.getSerializationHeader() != null);
            builder.setStatsMetadata(statsComponent.statsMetadata());
            if (this.descriptor.version.hasKeyRange() && statsComponent.statsMetadata() != null) {
                builder.setFirst(this.tableMetadataRef.getLocal().partitioner.decorateKey(statsComponent.statsMetadata().firstKey));
                builder.setLast(this.tableMetadataRef.getLocal().partitioner.decorateKey(statsComponent.statsMetadata().lastKey));
            }
            ValidationMetadata validationMetadata = statsComponent.validationMetadata();
            this.validatePartitioner(builder.getTableMetadataRef().getLocal(), validationMetadata);
            boolean filterNeeded = online;
            if (filterNeeded) {
                builder.setFilter(this.loadFilter(validationMetadata));
            }
            boolean rebuildFilter = filterNeeded && builder.getFilter() == null;
            boolean summaryNeeded = true;
            if (summaryNeeded && (summaryComponent = this.loadSummary()) != null) {
                if (builder.getFirst() == null || builder.getLast() == null) {
                    builder.setFirst(summaryComponent.first);
                    builder.setLast(summaryComponent.last);
                }
                builder.setIndexSummary(summaryComponent.indexSummary);
            }
            boolean bl = rebuildSummary = summaryNeeded && builder.getIndexSummary() == null;
            if (builder.getComponents().contains(BigFormat.Components.PRIMARY_INDEX) && (rebuildFilter || rebuildSummary)) {
                try (FileHandle indexFile = this.indexFileBuilder(builder.getIndexSummary()).complete();){
                    Pair<IFilter, IndexSummaryComponent> filterAndSummary = this.buildSummaryAndBloomFilter(indexFile, builder.getSerializationHeader(), rebuildFilter, rebuildSummary, owner != null ? owner.getMetrics() : null);
                    IFilter filter = (IFilter)filterAndSummary.left;
                    IndexSummaryComponent summaryComponent2 = (IndexSummaryComponent)filterAndSummary.right;
                    if (summaryComponent2 != null) {
                        builder.setFirst(summaryComponent2.first);
                        builder.setLast(summaryComponent2.last);
                        builder.setIndexSummary(summaryComponent2.indexSummary);
                        if (online) {
                            summaryComponent2.save(this.descriptor.fileFor(BigFormat.Components.SUMMARY), false);
                        }
                    }
                    if (filter != null) {
                        builder.setFilter(filter);
                        if (online) {
                            FilterComponent.save(filter, this.descriptor, false);
                        }
                    }
                }
            }
            try (CompressionMetadata compressionMetadata = CompressionInfoComponent.maybeLoad(this.descriptor, this.components);){
                builder.setDataFile(this.dataFileBuilder(builder.getStatsMetadata()).withCompressionMetadata(compressionMetadata).withCrcCheckChance(() -> this.tableMetadataRef.getLocal().params.crcCheckChance).complete());
            }
            if (builder.getFilter() == null) {
                builder.setFilter(FilterFactory.AlwaysPresent);
            }
            if (builder.getComponents().contains(BigFormat.Components.PRIMARY_INDEX)) {
                builder.setIndexFile(this.indexFileBuilder(builder.getIndexSummary()).complete());
            }
        }
        catch (IOException | Error | RuntimeException ex) {
            Throwables.closeNonNullAndAddSuppressed(ex, builder.getDataFile(), builder.getIndexFile(), builder.getFilter(), builder.getIndexSummary());
            throw ex;
        }
    }

    @Override
    public KeyReader buildKeyReader(TableMetrics tableMetrics) throws IOException {
        StatsComponent statsComponent = StatsComponent.load(this.descriptor, MetadataType.STATS, MetadataType.HEADER, MetadataType.VALIDATION);
        SerializationHeader header = statsComponent.serializationHeader(this.tableMetadataRef.getLocal());
        try (FileHandle indexFile = this.indexFileBuilder(null).complete();){
            KeyReader keyReader = this.createKeyReader(indexFile, header, tableMetrics);
            return keyReader;
        }
    }

    private KeyReader createKeyReader(FileHandle indexFile, SerializationHeader serializationHeader, TableMetrics tableMetrics) throws IOException {
        Preconditions.checkNotNull(indexFile);
        Preconditions.checkNotNull(serializationHeader);
        RowIndexEntry.Serializer serializer = new RowIndexEntry.Serializer(this.descriptor.version, serializationHeader, tableMetrics);
        return BigTableKeyReader.create(indexFile, (RowIndexEntry.IndexSerializer)serializer);
    }

    private Pair<IFilter, IndexSummaryComponent> buildSummaryAndBloomFilter(FileHandle indexFile, SerializationHeader serializationHeader, boolean rebuildFilter, boolean rebuildSummary, TableMetrics tableMetrics) throws IOException {
        Preconditions.checkNotNull(indexFile);
        Preconditions.checkNotNull(serializationHeader);
        DecoratedKey first = null;
        DecoratedKey key = null;
        IFilter bf = null;
        IndexSummary indexSummary = null;
        try (KeyReader keyReader = this.createKeyReader(indexFile, serializationHeader, tableMetrics);){
            long estimatedRowsNumber;
            long l = estimatedRowsNumber = rebuildFilter || rebuildSummary ? this.estimateRowsFromIndex(indexFile) : 0L;
            if (rebuildFilter) {
                bf = FilterFactory.getFilter(estimatedRowsNumber, this.tableMetadataRef.getLocal().params.bloomFilterFpChance);
            }
            try (IndexSummaryBuilder summaryBuilder = !rebuildSummary ? null : new IndexSummaryBuilder(estimatedRowsNumber, this.tableMetadataRef.getLocal().params.minIndexInterval, 128);){
                while (!keyReader.isExhausted()) {
                    key = this.tableMetadataRef.getLocal().partitioner.decorateKey(keyReader.key());
                    if (rebuildSummary) {
                        if (first == null) {
                            first = key;
                        }
                        summaryBuilder.maybeAddEntry(key, keyReader.keyPositionForSecondaryIndex());
                    }
                    if (rebuildFilter) {
                        bf.add(key);
                    }
                    keyReader.advance();
                }
                if (rebuildSummary) {
                    indexSummary = summaryBuilder.build(this.tableMetadataRef.getLocal().partitioner);
                }
            }
        }
        catch (IOException | Error | RuntimeException ex) {
            Throwables.closeNonNullAndAddSuppressed(ex, indexSummary, bf);
            throw ex;
        }
        assert (rebuildSummary || indexSummary == null);
        return Pair.create(bf, rebuildSummary ? new IndexSummaryComponent(indexSummary, first, key) : null);
    }

    private IndexSummaryComponent loadSummary() {
        IndexSummaryComponent summaryComponent = null;
        try {
            if (this.components.contains(BigFormat.Components.SUMMARY)) {
                summaryComponent = IndexSummaryComponent.loadOrDeleteCorrupted(this.descriptor.fileFor(BigFormat.Components.SUMMARY), this.tableMetadataRef.get());
            }
            if (summaryComponent == null) {
                logger.debug("Index summary file is missing: {}", (Object)this.descriptor.fileFor(BigFormat.Components.SUMMARY));
            }
        }
        catch (IOException ex) {
            logger.debug("Index summary file is corrupted: " + this.descriptor.fileFor(BigFormat.Components.SUMMARY), (Throwable)ex);
        }
        return summaryComponent;
    }

    public long estimateRowsFromIndex(FileHandle indexFile) throws IOException {
        Preconditions.checkNotNull(indexFile);
        try (RandomAccessReader indexReader = indexFile.createReader();){
            int keys;
            int samplesCap = 10000;
            int bytesCap = (int)Math.min(10000000L, indexReader.length());
            for (keys = 0; indexReader.getFilePointer() < (long)bytesCap && keys < 10000; ++keys) {
                ByteBufferUtil.skipShortLength(indexReader);
                RowIndexEntry.Serializer.skip(indexReader, this.descriptor.version);
            }
            assert (keys > 0 && indexReader.getFilePointer() > 0L && indexReader.length() > 0L) : "Unexpected empty index file: " + indexReader;
            long estimatedRows = indexReader.length() / (indexReader.getFilePointer() / (long)keys);
            indexReader.seek(0L);
            long l = estimatedRows;
            return l;
        }
    }

    private FileHandle.Builder indexFileBuilder(IndexSummary indexSummary) {
        OptionalInt indexBufferSize;
        assert (this.indexFileBuilder == null || this.indexFileBuilder.file.equals(this.descriptor.fileFor(BigFormat.Components.PRIMARY_INDEX)));
        long indexFileLength = this.descriptor.fileFor(BigFormat.Components.PRIMARY_INDEX).length();
        OptionalInt optionalInt = indexBufferSize = indexSummary != null ? OptionalInt.of(this.ioOptions.diskOptimizationStrategy.bufferSize(indexFileLength / (long)indexSummary.size())) : OptionalInt.empty();
        if (this.indexFileBuilder == null) {
            this.indexFileBuilder = IndexComponent.fileBuilder(this.descriptor.fileFor(BigFormat.Components.PRIMARY_INDEX), this.ioOptions, this.chunkCache).bufferSize(indexBufferSize.orElse(65536));
        }
        indexBufferSize.ifPresent(this.indexFileBuilder::bufferSize);
        return this.indexFileBuilder;
    }
}

