/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.math.DoubleMath;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="getstreamthroughput", description="Print the throughput cap for streaming and entire SSTable streaming in the system in rounded megabits. For precise number, please, use option -d")
public class GetStreamThroughput
extends NodeTool.NodeToolCmd {
    @Option(name={"-e", "--entire-sstable-throughput"}, description="Print entire SSTable streaming throughput in MiB/s")
    private boolean entireSSTableThroughput;
    @Option(name={"-m", "--mib"}, description="Print the throughput cap for streaming in MiB/s")
    private boolean streamThroughputMiB;
    @Option(name={"-d", "--precise-mbit"}, description="Print the throughput cap for streaming in precise Mbits (double)")
    private boolean streamThroughputDoubleMbit;

    @Override
    public void execute(NodeProbe probe) {
        if (this.entireSSTableThroughput) {
            if (this.streamThroughputDoubleMbit || this.streamThroughputMiB) {
                throw new IllegalArgumentException("You cannot use more than one flag with this command");
            }
            double throughputInDouble = probe.getEntireSSTableStreamThroughput();
            probe.output().out.printf("Current entire SSTable stream throughput: %s%n", throughputInDouble > 0.0 ? throughputInDouble + " MiB/s" : "unlimited");
        } else if (this.streamThroughputMiB) {
            if (this.streamThroughputDoubleMbit) {
                throw new IllegalArgumentException("You cannot use more than one flag with this command");
            }
            double throughputInDouble = probe.getStreamThroughputMibAsDouble();
            probe.output().out.printf("Current stream throughput: %s%n", throughputInDouble > 0.0 ? throughputInDouble + " MiB/s" : "unlimited");
        } else if (this.streamThroughputDoubleMbit) {
            double throughputInDouble = probe.getStreamThroughputAsDouble();
            probe.output().out.printf("Current stream throughput: %s%n", throughputInDouble > 0.0 ? throughputInDouble + " Mb/s" : "unlimited");
        } else {
            double throughputInDouble = probe.getStreamThroughputAsDouble();
            int throughput = probe.getStreamThroughput();
            if (throughput <= 0) {
                probe.output().out.printf("Current stream throughput: unlimited%n", new Object[0]);
            } else if (DoubleMath.isMathematicalInteger(throughputInDouble)) {
                probe.output().out.printf("Current stream throughput: %s%n", throughput + " Mb/s");
            } else {
                throw new RuntimeException("Use the -d flag to quiet this error and get the exact throughput in megabits/s");
            }
        }
    }
}

