/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.DirectDataTransferApi;
import org.apache.cassandra.spark.bulkwriter.DirectStreamSession;
import org.apache.cassandra.spark.bulkwriter.MockBulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.MockScheduledExecutorService;
import org.apache.cassandra.spark.bulkwriter.MockTableWriter;
import org.apache.cassandra.spark.bulkwriter.NonValidatingTestSortedSSTableWriter;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.SortedSSTableWriter;
import org.apache.cassandra.spark.bulkwriter.StreamResult;
import org.apache.cassandra.spark.bulkwriter.StreamSession;
import org.apache.cassandra.spark.bulkwriter.TokenRangeMappingUtils;
import org.apache.cassandra.spark.bulkwriter.TransportContext;
import org.apache.cassandra.spark.bulkwriter.token.MultiClusterReplicaAwareFailureHandler;
import org.apache.cassandra.spark.bulkwriter.token.ReplicaAwareFailureHandler;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.cassandra.spark.common.model.CassandraInstance;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.exception.ConsistencyNotSatisfiedException;
import org.apache.cassandra.spark.utils.DigestAlgorithm;
import org.apache.cassandra.spark.utils.XXHash32DigestAlgorithm;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class DirectStreamSessionTest {
    public static final String LOAD_RANGE_ERROR_PREFIX = "Failed to write 1 ranges with LOCAL_QUORUM";
    private static final Map<String, Object> COLUMN_BOUND_VALUES = ImmutableMap.of((Object)"id", (Object)0, (Object)"date", (Object)1, (Object)"course", (Object)"course", (Object)"marks", (Object)2);
    @TempDir
    private Path folder;
    private static final int FILES_PER_SSTABLE = 8;
    private static final int RF = 3;
    private MockBulkWriterContext writerContext;
    private TransportContext.DirectDataBulkWriterContext transportContext;
    private List<String> expectedInstances;
    private TokenRangeMapping<RingInstance> tokenRangeMapping;
    private MockScheduledExecutorService executor;
    private MockTableWriter tableWriter;
    private Range<BigInteger> range;
    private DigestAlgorithm digestAlgorithm;

    @BeforeEach
    public void setup() {
        this.digestAlgorithm = new XXHash32DigestAlgorithm();
        this.range = Range.range((Comparable)BigInteger.valueOf(101L), (BoundType)BoundType.CLOSED, (Comparable)BigInteger.valueOf(199L), (BoundType)BoundType.CLOSED);
        ImmutableMap rfOptions = ImmutableMap.of((Object)"DC1", (Object)3);
        ReplicationFactor rf = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)rfOptions);
        this.tokenRangeMapping = TokenRangeMappingUtils.buildTokenRangeMapping(0, (ImmutableMap<String, Integer>)rfOptions, 12);
        this.writerContext = this.getBulkWriterContext();
        this.writerContext.setReplicationFactor(rf);
        this.tableWriter = new MockTableWriter(this.folder);
        this.transportContext = (TransportContext.DirectDataBulkWriterContext)this.writerContext.transportContext();
        this.executor = new MockScheduledExecutorService();
        this.expectedInstances = Lists.newArrayList((Object[])new String[]{"DC1-i2", "DC1-i3", "DC1-i4"});
    }

    @Test
    void testGetReplicasReturnsCorrectData() {
        DirectStreamSession streamSession = this.createStreamSession(SortedSSTableWriter::new);
        List replicas = streamSession.getReplicas();
        Assertions.assertThat((List)replicas).isNotNull();
        List actualInstances = replicas.stream().map(RingInstance::nodeName).collect(Collectors.toList());
        Assertions.assertThat(actualInstances).containsExactlyInAnyOrder((Object[])this.expectedInstances.toArray(new String[0]));
    }

    @Test
    void testScheduleStreamSendsCorrectFilesToCorrectInstances() throws IOException, ExecutionException, InterruptedException {
        DirectStreamSession ss = this.createStreamSession(NonValidatingTestSortedSSTableWriter::new);
        ss.addRow(BigInteger.valueOf(102L), COLUMN_BOUND_VALUES);
        Assertions.assertThat((long)ss.rowCount()).isEqualTo(1L);
        StreamResult streamResult = (StreamResult)ss.finalizeStreamAsync().get();
        Assertions.assertThat((long)streamResult.rowCount).isEqualTo(1L);
        this.executor.assertFuturesCalled();
        Assertions.assertThat(this.executor.futures).hasSize(1);
        Assertions.assertThat((int)this.writerContext.getUploads().values().stream().mapToInt(Collection::size).sum()).isEqualTo(24);
        List instances = this.writerContext.getUploads().keySet().stream().map(CassandraInstance::nodeName).collect(Collectors.toList());
        Assertions.assertThat(instances).containsExactlyInAnyOrder((Object[])this.expectedInstances.toArray(new String[0]));
    }

    @Test
    void testEmptyTokenRangeFails() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DirectStreamSession((BulkWriterContext)this.writerContext, (SortedSSTableWriter)new NonValidatingTestSortedSSTableWriter(this.tableWriter, this.folder, this.digestAlgorithm, 1), this.transportContext, "sessionId", Range.range((Comparable)BigInteger.valueOf(0L), (BoundType)BoundType.OPEN, (Comparable)BigInteger.valueOf(0L), (BoundType)BoundType.CLOSED), this.replicaAwareFailureHandler(), null)).isInstanceOf(IllegalStateException.class)).hasMessage("No replicas found for range (0\u20250]");
    }

    @Test
    void testMismatchedTokenRangeFails() throws IOException {
        DirectStreamSession ss = this.createStreamSession(NonValidatingTestSortedSSTableWriter::new);
        ss.addRow(BigInteger.valueOf(9999L), COLUMN_BOUND_VALUES);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((StreamSession)ss).finalizeStreamAsync()).isInstanceOf(IllegalStateException.class)).hasMessageMatching("SSTable range \\[9999(\u2025|..)9999] should be enclosed in the partition range \\[101(\u2025|..)199]");
    }

    @Test
    void testUploadFailureCallsClean() throws IOException, ExecutionException, InterruptedException {
        this.runFailedUpload();
        List actualInstances = this.writerContext.getCleanedInstances().stream().map(CassandraInstance::nodeName).collect(Collectors.toList());
        Assertions.assertThat(actualInstances).containsExactlyInAnyOrder((Object[])this.expectedInstances.toArray(new String[0]));
    }

    @Test
    void testUploadFailureSkipsCleanWhenConfigured() throws IOException, ExecutionException, InterruptedException {
        this.writerContext.setSkipCleanOnFailures(true);
        this.runFailedUpload();
        List actualInstances = this.writerContext.getCleanedInstances().stream().map(CassandraInstance::nodeName).collect(Collectors.toList());
        Assertions.assertThat(actualInstances).isEmpty();
        List uploads = this.writerContext.getUploads().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        Assertions.assertThat(uploads).isNotEmpty();
        Assertions.assertThat(uploads).allMatch(u -> !u.uploadSucceeded);
    }

    @Test
    void testUploadFailureRefreshesClusterInfo() throws IOException, ExecutionException, InterruptedException {
        this.runFailedUpload();
        Assertions.assertThat((int)this.writerContext.refreshClusterInfoCallCount()).isEqualTo(3);
    }

    @Test
    void testOutDirCreationFailureCleansAllReplicas() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            DirectStreamSession ss = this.createStreamSession(NonValidatingTestSortedSSTableWriter::new);
            ss.addRow(BigInteger.valueOf(102L), COLUMN_BOUND_VALUES);
            Future fut = ss.finalizeStreamAsync();
            this.tableWriter.removeOutDir();
            fut.get();
        }).isInstanceOf(ExecutionException.class)).hasRootCauseInstanceOf(NoSuchFileException.class);
        List actualInstances = this.writerContext.getCleanedInstances().stream().map(CassandraInstance::nodeName).collect(Collectors.toList());
        Assertions.assertThat(actualInstances).containsExactlyInAnyOrder((Object[])this.expectedInstances.toArray(new String[0]));
    }

    @Test
    void failedCleanDoesNotThrow() throws IOException {
        this.writerContext.setCleanShouldThrow(true);
        this.runFailedUpload();
    }

    @Test
    void testLocalQuorumSucceedsWhenSingleCommitFails() throws IOException, ExecutionException, InterruptedException {
        DirectStreamSession ss = this.createStreamSession(NonValidatingTestSortedSSTableWriter::new);
        AtomicBoolean success = new AtomicBoolean(true);
        this.writerContext.setCommitResultSupplier((uuids, dc) -> {
            if (success.getAndSet(false)) {
                return new DirectDataTransferApi.RemoteCommitResult(false, uuids, null, "");
            }
            return new DirectDataTransferApi.RemoteCommitResult(true, null, uuids, "");
        });
        ss.addRow(BigInteger.valueOf(102L), COLUMN_BOUND_VALUES);
        ss.finalizeStreamAsync().get();
        this.executor.assertFuturesCalled();
        Assertions.assertThat((int)this.writerContext.getUploads().values().stream().mapToInt(Collection::size).sum()).isEqualTo(24);
        List instances = this.writerContext.getUploads().keySet().stream().map(CassandraInstance::nodeName).collect(Collectors.toList());
        Assertions.assertThat(instances).containsExactlyInAnyOrder((Object[])this.expectedInstances.toArray(new String[0]));
    }

    @Test
    void testLocalQuorumFailsWhenCommitsFail() throws IOException {
        DirectStreamSession ss = this.createStreamSession(NonValidatingTestSortedSSTableWriter::new);
        AtomicBoolean success = new AtomicBoolean(true);
        this.writerContext.setCommitResultSupplier((uuids, dc) -> {
            if (success.getAndSet(false)) {
                return new DirectDataTransferApi.RemoteCommitResult(true, null, uuids, "");
            }
            return new DirectDataTransferApi.RemoteCommitResult(false, uuids, null, "");
        });
        ss.addRow(BigInteger.valueOf(102L), COLUMN_BOUND_VALUES);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DirectStreamSessionTest.lambda$testLocalQuorumFailsWhenCommitsFail$5((StreamSession)ss)).isInstanceOf(ExecutionException.class)).hasCauseExactlyInstanceOf(ConsistencyNotSatisfiedException.class).hasMessageContaining("Failed to write 1 ranges with LOCAL_QUORUM for job " + this.writerContext.job().getId() + " in phase UploadAndCommit.");
        this.executor.assertFuturesCalled();
        Assertions.assertThat((int)this.writerContext.getUploads().values().stream().mapToInt(Collection::size).sum()).isEqualTo(24);
        List instances = this.writerContext.getUploads().keySet().stream().map(CassandraInstance::nodeName).collect(Collectors.toList());
        Assertions.assertThat(instances).containsExactlyInAnyOrder((Object[])this.expectedInstances.toArray(new String[0]));
    }

    private void runFailedUpload() throws IOException {
        this.writerContext.setUploadSupplier(instance -> false);
        DirectStreamSession ss = this.createStreamSession(NonValidatingTestSortedSSTableWriter::new);
        ss.addRow(BigInteger.valueOf(102L), COLUMN_BOUND_VALUES);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DirectStreamSessionTest.lambda$runFailedUpload$7((StreamSession)ss)).isInstanceOf(ExecutionException.class)).hasCauseInstanceOf(Exception.class).extracting(Throwable::getCause).extracting(Throwable::getMessage).asString().startsWith((CharSequence)LOAD_RANGE_ERROR_PREFIX);
    }

    @NotNull
    private MockBulkWriterContext getBulkWriterContext() {
        return new MockBulkWriterContext(this.tokenRangeMapping);
    }

    @NotNull
    private ReplicaAwareFailureHandler<RingInstance> replicaAwareFailureHandler() {
        return new MultiClusterReplicaAwareFailureHandler(this.writerContext.cluster().getPartitioner());
    }

    private DirectStreamSession createStreamSession(MockTableWriter.Creator writerCreator) {
        return new DirectStreamSession((BulkWriterContext)this.writerContext, writerCreator.create(this.tableWriter, this.folder, this.digestAlgorithm, 1), this.transportContext, "sessionId", this.range, this.replicaAwareFailureHandler(), (ExecutorService)this.executor);
    }

    private static /* synthetic */ void lambda$runFailedUpload$7(StreamSession ss) throws Throwable {
        ss.finalizeStreamAsync().get();
    }

    private static /* synthetic */ void lambda$testLocalQuorumFailsWhenCommitsFail$5(StreamSession ss) throws Throwable {
        ss.finalizeStreamAsync().get();
    }
}

