/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.spark.bulkwriter.BulkSparkConf;
import org.apache.cassandra.spark.bulkwriter.BulkWriterConfig;
import org.apache.cassandra.spark.bulkwriter.CassandraBulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.SchemaInfo;
import org.apache.cassandra.spark.bulkwriter.TransportContext;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CassandraCoordinatedBulkWriterContext;
import org.apache.cassandra.spark.common.stats.JobStatsPublisher;

public interface BulkWriterContext {
    public ClusterInfo cluster();

    public JobInfo job();

    public JobStatsPublisher jobStats();

    public SchemaInfo schema();

    public CassandraBridge bridge();

    public void shutdown();

    public TransportContext transportContext();

    public static BulkWriterContext from(BulkWriterConfig config) {
        BulkSparkConf conf = config.getConf();
        if (conf.isCoordinatedWriteConfigured()) {
            return new CassandraCoordinatedBulkWriterContext(config);
        }
        return new CassandraBulkWriterContext(config);
    }
}

