/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import org.apache.cassandra.spark.common.model.NodeState;
import org.apache.cassandra.spark.common.model.NodeStatus;

public enum WriteAvailability {
    AVAILABLE("is available"),
    UNAVAILABLE_DOWN("is down"),
    INVALID_STATE("is in an invalid state");

    private final String message;

    private WriteAvailability(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public static WriteAvailability determineFromNodeState(NodeState nodeState, NodeStatus nodeStatus) {
        if (nodeStatus != NodeStatus.UP) {
            return UNAVAILABLE_DOWN;
        }
        if (nodeState == NodeState.NORMAL || nodeState.isPending) {
            return AVAILABLE;
        }
        return INVALID_STATE;
    }
}

