/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.client.request;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.cassandra.sidecar.client.RequestContext;
import org.apache.cassandra.sidecar.client.request.RequestTestParameters;
import org.apache.cassandra.sidecar.common.response.RingResponse;
import org.apache.cassandra.sidecar.common.response.data.RingEntry;
import org.assertj.core.api.Assertions;

public class RingRequestForKeyspaceTestParameters
implements RequestTestParameters<RingResponse> {
    public static final String KEYSPACE = "testkeyspace";

    @Override
    public RequestContext.Builder specificRequest(RequestContext.Builder requestContextBuilder) {
        return requestContextBuilder.ringRequest(KEYSPACE);
    }

    @Override
    public String okResponseBody() {
        return "[{\"datacenter\":\"LO\",\"address\":\"172.17.0.2\",\"port\":7000,\"rack\":\"101000101\",\"status\":\"Up\",\"state\":\"Normal\",\"load\":\"86.99 KiB\",\"owns\":\"100.00%\",\"token\":\"-9223372036854775808\",\"fqdn\":\"172.17.0.2\",\"hostId\":\"33cae238-8203-41c1-880f-8cdf98ee6720\"},{\"datacenter\":\"LO\",\"address\":\"127.0.0.2\",\"port\":7000,\"rack\":\"101000201\",\"status\":\"Up\",\"state\":\"Normal\",\"load\":\"87 KiB\",\"owns\":\"100.00%\",\"token\":\"-3074457345618258603\",\"fqdn\":\"127.0.0.2\",\"hostId\":\"dba02656-ea8c-4a1d-8011-cbc0dab5f411\"},{\"datacenter\":\"LO\",\"address\":\"127.0.0.3\",\"port\":7000,\"rack\":\"101000301\",\"status\":\"Up\",\"state\":\"Normal\",\"load\":\"87 KiB\",\"owns\":\"100.00%\",\"token\":\"3074457345618258602\",\"fqdn\":\"127.0.0.3\",\"hostId\":\"be19c254-becb-40b9-8951-30c589c7028e\"}]";
    }

    @Override
    public String expectedEndpointPath() {
        return "/api/v1/cassandra/ring/keyspaces/:keyspace".replaceAll(":keyspace", KEYSPACE);
    }

    @Override
    public void validateResponse(RingResponse response) {
        Assertions.assertThat((int)response.size()).isEqualTo(3);
        List ringEntryList = StreamSupport.stream(response.spliterator(), false).collect(Collectors.toList());
        Assertions.assertThat((String)((RingEntry)ringEntryList.get(0)).token()).isEqualTo("-9223372036854775808");
        Assertions.assertThat((String)((RingEntry)ringEntryList.get(1)).token()).isEqualTo("-3074457345618258603");
        Assertions.assertThat((String)((RingEntry)ringEntryList.get(2)).token()).isEqualTo("3074457345618258602");
    }
}

