/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.Bundle;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.BundleStorageObject;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.DataChunker;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.StorageClientConfig;
import org.apache.cassandra.spark.transports.storage.StorageCredentials;
import org.apache.cassandra.spark.transports.storage.extensions.StorageTransportConfiguration;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.model.Tagging;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

public class StorageClient
implements AutoCloseable {
    public static final char SEPARATOR = '/';
    private final StorageTransportConfiguration storageTransportConfiguration;
    private final DataChunker dataChunker;
    private final Tagging tagging;
    private final S3AsyncClient client;
    private final Map<StorageCredentials, AwsCredentialsProvider> credentialsCache;

    public StorageClient(StorageTransportConfiguration storageTransportConfiguration, StorageClientConfig storageClientConfig) {
        this.storageTransportConfiguration = storageTransportConfiguration;
        ThreadPoolExecutor executor = new ThreadPoolExecutor(storageClientConfig.concurrency, storageClientConfig.concurrency, storageClientConfig.threadKeepAliveSeconds, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().threadNamePrefix(storageClientConfig.threadNamePrefix).daemonThreads(Boolean.valueOf(true)).build());
        executor.allowCoreThreadTimeOut(true);
        Map<SdkAdvancedAsyncClientOption, ThreadPoolExecutor> advancedOptions = Collections.singletonMap(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, executor);
        String region = storageTransportConfiguration.writeAccessConfiguration().region();
        S3AsyncClientBuilder clientBuilder = (S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().region(Region.of((String)region))).asyncConfiguration(b -> b.advancedOptions(advancedOptions));
        if (storageClientConfig.endpointOverride != null) {
            ((S3AsyncClientBuilder)clientBuilder.endpointOverride(storageClientConfig.endpointOverride)).forcePathStyle(Boolean.valueOf(true));
        }
        if (storageClientConfig.httpsProxy != null) {
            ProxyConfiguration proxyConfig = (ProxyConfiguration)ProxyConfiguration.builder().host(storageClientConfig.httpsProxy.getHost()).port(storageClientConfig.httpsProxy.getPort()).scheme(storageClientConfig.httpsProxy.getScheme()).build();
            Duration connectionAcquisitionTimeout = Duration.ofSeconds(storageClientConfig.nioHttpClientConnectionAcquisitionTimeoutSeconds);
            clientBuilder.httpClient(NettyNioAsyncHttpClient.builder().proxyConfiguration(proxyConfig).connectionAcquisitionTimeout(connectionAcquisitionTimeout).maxConcurrency(Integer.valueOf(storageClientConfig.nioHttpClientMaxConcurrency)).build());
        }
        this.client = (S3AsyncClient)clientBuilder.build();
        this.dataChunker = new DataChunker(storageClientConfig.maxChunkSizeInBytes);
        List tags = this.storageTransportConfiguration.getObjectTags().entrySet().stream().map(entry -> (Tag)Tag.builder().key((String)entry.getKey()).value((String)entry.getValue()).build()).collect(Collectors.toList());
        this.tagging = (Tagging)Tagging.builder().tagSet(tags).build();
        this.credentialsCache = new ConcurrentHashMap<StorageCredentials, AwsCredentialsProvider>();
    }

    public BundleStorageObject multiPartUpload(StorageCredentials credentials, Bundle bundle) throws IOException, ExecutionException, InterruptedException {
        if (credentials == null) {
            throw new IllegalArgumentException("No credentials provided for uploading bundles");
        }
        String key = this.calculateStorageKeyForBundle(this.storageTransportConfiguration.getPrefix(), bundle.bundleFile);
        String bucket = this.storageTransportConfiguration.writeAccessConfiguration().bucket();
        CreateMultipartUploadRequest multipartUploadRequest = (CreateMultipartUploadRequest)CreateMultipartUploadRequest.builder().overrideConfiguration(this.credentialsOverride(credentials)).bucket(bucket).key(key).tagging(this.tagging).build();
        CreateMultipartUploadResponse multipartUploadResponse = (CreateMultipartUploadResponse)this.client.createMultipartUpload(multipartUploadRequest).get();
        String uploadId = multipartUploadResponse.uploadId();
        List<CompletedPart> completedParts = this.uploadPartsOfBundle(key, uploadId, credentials, bundle);
        CompletedMultipartUpload completedUpload = (CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(completedParts).build();
        CompleteMultipartUploadRequest completeMultipartUploadRequest = (CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().overrideConfiguration(this.credentialsOverride(credentials)).bucket(bucket).key(key).uploadId(uploadId).multipartUpload(completedUpload).build();
        CompleteMultipartUploadResponse completeMultipartUploadResponse = (CompleteMultipartUploadResponse)this.client.completeMultipartUpload(completeMultipartUploadRequest).get();
        return BundleStorageObject.builder().bundle(bundle).storageObjectKey(key).storageObjectChecksum(completeMultipartUploadResponse.eTag()).build();
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    private List<CompletedPart> uploadPartsOfBundle(String key, String uploadId, StorageCredentials credentials, Bundle bundle) throws IOException, ExecutionException, InterruptedException {
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        String bucket = this.storageTransportConfiguration.writeAccessConfiguration().bucket();
        try (ReadableByteChannel channel = Channels.newChannel(Files.newInputStream(bundle.bundleFile, new OpenOption[0]));){
            Iterator<ByteBuffer> chunks = this.dataChunker.chunks(channel);
            int partNumber = 1;
            while (chunks.hasNext()) {
                int loopPartNumber = partNumber++;
                ByteBuffer buffer = chunks.next();
                AsyncRequestBody body = AsyncRequestBody.fromRemainingByteBuffer((ByteBuffer)buffer);
                UploadPartRequest uploadPartRequest = (UploadPartRequest)UploadPartRequest.builder().overrideConfiguration(this.credentialsOverride(credentials)).bucket(bucket).key(key).uploadId(uploadId).partNumber(Integer.valueOf(loopPartNumber)).build();
                Function<UploadPartResponse, CompletedPart> buildPart = r -> (CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(loopPartNumber)).eTag(r.eTag()).build();
                CompletionStage completedPart = this.client.uploadPart(uploadPartRequest, body).thenApply(buildPart);
                futures.add(completedPart);
            }
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get();
        return futures.stream().map(CompletableFuture::join).collect(Collectors.toList());
    }

    private String calculateStorageKeyForBundle(String prefix, Path bundleLocation) {
        return prefix + "/" + String.valueOf(bundleLocation.getFileName());
    }

    private AwsCredentialsProvider toCredentialsProvider(StorageCredentials storageCredentials) {
        AwsSessionCredentials credentials = AwsSessionCredentials.create((String)storageCredentials.getAccessKeyId(), (String)storageCredentials.getSecretKey(), (String)storageCredentials.getSessionToken());
        return StaticCredentialsProvider.create((AwsCredentials)credentials);
    }

    private Consumer<AwsRequestOverrideConfiguration.Builder> credentialsOverride(StorageCredentials credentials) {
        return b -> b.credentialsProvider(this.credentialsCache.computeIfAbsent(credentials, this::toCredentialsProvider));
    }
}

