/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import com.google.common.base.Preconditions;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.spark.sparksql.filters.SSTableTimeRangeFilter;
import org.apache.cassandra.spark.utils.MapUtils;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.In;

public final class FilterUtils {
    private FilterUtils() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static Map<String, List<String>> extractPartitionKeyValues(Filter[] filters, Set<String> partitionKeyColumnNames) {
        HashMap<String, List<String>> keyValuePairs = new HashMap<String, List<String>>();
        Arrays.stream(filters).filter(filter -> filter instanceof EqualTo || filter instanceof In).forEach(filter -> {
            AbstractMap.SimpleEntry<String, List<String>> filterKeyValue = filter instanceof EqualTo ? new AbstractMap.SimpleEntry<String, List<String>>(((EqualTo)filter).attribute(), Collections.singletonList(((EqualTo)filter).value().toString())) : new AbstractMap.SimpleEntry(((In)filter).attribute(), Arrays.stream(((In)filter).values()).map(Object::toString).collect(Collectors.toList()));
            Preconditions.checkArgument((!keyValuePairs.containsKey(filterKeyValue.getKey()) ? 1 : 0) != 0, (Object)("Duplicate filter passed for key " + filterKeyValue.getKey()));
            if (partitionKeyColumnNames.contains(filterKeyValue.getKey())) {
                keyValuePairs.put(filterKeyValue.getKey(), filterKeyValue.getValue());
            }
        });
        if (keyValuePairs.size() == 0) {
            return Collections.emptyMap();
        }
        Preconditions.checkArgument((boolean)keyValuePairs.keySet().containsAll(partitionKeyColumnNames), (Object)"Invalid filter, all partition key parts must be restricted by = or in");
        return keyValuePairs;
    }

    public static List<List<String>> cartesianProduct(List<List<String>> orderedValues) {
        ArrayList<List<String>> combinations = new ArrayList<List<String>>();
        Preconditions.checkArgument((boolean)orderedValues.stream().noneMatch(List::isEmpty));
        int sizeOfProduct = orderedValues.size();
        int[] indices = new int[sizeOfProduct];
        block0: while (true) {
            int position;
            ArrayList<String> currProduct = new ArrayList<String>();
            for (int index = 0; index < sizeOfProduct; ++index) {
                currProduct.add(orderedValues.get(index).get(indices[index]));
            }
            combinations.add(currProduct);
            for (position = 0; position < sizeOfProduct && indices[position] + 1 >= orderedValues.get(position).size(); ++position) {
            }
            if (position == sizeOfProduct) {
                return combinations;
            }
            int n = position;
            indices[n] = indices[n] + 1;
            int index = position - 1;
            while (true) {
                if (index < 0) continue block0;
                indices[index] = 0;
                --index;
            }
            break;
        }
    }

    public static SSTableTimeRangeFilter parseSSTableTimeRangeFilter(Map<String, String> options) {
        if (!options.containsKey("sstable_start_timestamp_micros") && !options.containsKey("sstable_end_timestamp_micros")) {
            return SSTableTimeRangeFilter.ALL;
        }
        long startTimestamp = MapUtils.getLong(options, (String)"sstable_start_timestamp_micros", (long)0L);
        long endTimestamp = MapUtils.getLong(options, (String)"sstable_end_timestamp_micros", (long)Long.MAX_VALUE);
        return SSTableTimeRangeFilter.create((long)startTimestamp, (long)endTimestamp);
    }
}

