/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader;

import java.io.InputStream;
import java.math.BigInteger;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.bridge.TokenRange;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.bti.BtiReaderUtils;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.spark.data.FileType;
import org.apache.cassandra.spark.data.IncompleteSSTableException;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.reader.IndexConsumer;
import org.apache.cassandra.spark.reader.ReaderUtils;
import org.apache.cassandra.spark.reader.common.IIndexReader;
import org.apache.cassandra.spark.sparksql.filters.SparkRangeFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BtiIndexReader
implements IIndexReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(BtiIndexReader.class);
    private TokenRange ssTableRange = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BtiIndexReader(@NotNull SSTable ssTable, @NotNull TableMetadata metadata, @Nullable SparkRangeFilter rangeFilter, @NotNull Stats stats, @NotNull IndexConsumer consumer) {
        long now;
        long startTimeNanos = now = System.nanoTime();
        try {
            File file = ReaderUtils.constructFilename(metadata.keyspace, metadata.name, ssTable.getDataFileName());
            Descriptor descriptor = (Descriptor)Descriptor.fromFileWithComponent((File)file, (boolean)false).left;
            now = System.nanoTime();
            try (InputStream is = ssTable.openPrimaryIndexStream();){
                if (is == null) {
                    consumer.onFailure((Throwable)new IncompleteSSTableException(new FileType[]{FileType.INDEX}));
                    return;
                }
                if (rangeFilter != null) {
                    this.ssTableRange = ReaderUtils.tokenRangeFromIndex(metadata, ssTable);
                    if (!rangeFilter.overlaps(this.ssTableRange)) {
                        LOGGER.info("Skipping non-overlapping Partitions.db file rangeFilter='[{},{}]' sstableRange='[{},{}]'", new Object[]{rangeFilter.tokenRange().firstEnclosedValue(), rangeFilter.tokenRange().upperEndpoint(), this.ssTableRange.firstEnclosedValue(), this.ssTableRange.upperEndpoint()});
                        stats.indexFileSkipped();
                        return;
                    }
                    now = System.nanoTime();
                }
                BtiReaderUtils.consumePrimaryIndex(ssTable, metadata, descriptor, rangeFilter, consumer);
                stats.indexFileRead(System.nanoTime() - now);
                return;
            }
        }
        catch (Throwable t) {
            consumer.onFailure(t);
            return;
        }
        finally {
            consumer.onFinished(System.nanoTime() - startTimeNanos);
        }
    }

    public BigInteger firstToken() {
        return this.ssTableRange != null ? this.ssTableRange.firstEnclosedValue() : null;
    }

    public BigInteger lastToken() {
        return this.ssTableRange != null ? this.ssTableRange.upperEndpoint() : null;
    }

    public boolean ignore() {
        return false;
    }
}

