/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics;

import com.datastax.driver.core.Row;
import com.datastax.driver.core.UDTValue;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.cassandra.analytics.DataGenerationUtils;
import org.apache.cassandra.analytics.SharedClusterSparkIntegrationTestBase;
import org.apache.cassandra.distributed.api.ConsistencyLevel;
import org.apache.cassandra.distributed.api.ICoordinator;
import org.apache.cassandra.distributed.api.SimpleQueryResult;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;
import org.apache.cassandra.testing.TestUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;

class BulkWriteUdtTest
extends SharedClusterSparkIntegrationTestBase {
    static final QualifiedName UDT_TABLE_NAME = new QualifiedName("spark_test", "test_udt");
    static final QualifiedName NESTED_TABLE_NAME = new QualifiedName("spark_test", "test_nested_udt");
    public static final String TWO_FIELD_UDT_NAME = "two_field_udt";
    public static final String NESTED_FIELD_UDT_NAME = "nested_udt";
    public static final String UDT_TABLE_CREATE = "CREATE TABLE " + String.valueOf(UDT_TABLE_NAME) + " (\n          id BIGINT PRIMARY KEY,\n          udtfield two_field_udt);";
    public static final String TWO_FIELD_UDT_DEF = "CREATE TYPE " + UDT_TABLE_NAME.keyspace() + ".two_field_udt (\n            f1 text,\n            f2 int);";
    public static final String NESTED_UDT_DEF = "CREATE TYPE " + NESTED_TABLE_NAME.keyspace() + ".nested_udt (\n            n1 BIGINT,\n            n2 frozen<two_field_udt>);";
    public static final String NESTED_TABLE_CREATE = "CREATE TABLE " + String.valueOf(NESTED_TABLE_NAME) + "(\n           id BIGINT PRIMARY KEY,\n           nested nested_udt);";
    public static final String UDT_WITH_COLLECTIONS_TYPE_NAME = "udt_with_collections";
    public static final String UDT_WITH_COLLECTIONS_TYPE_CREATE = "CREATE TYPE spark_test.udt_with_collections (f1 list<text>, f2 set<int>, f3 map<int, text>);";
    public static final QualifiedName LIST_OF_UDT_SOURCE_TABLE = new QualifiedName("spark_test", "list_of_udt_src");
    public static final QualifiedName LIST_OF_UDT_DEST_TABLE = new QualifiedName("spark_test", "list_of_udt_dest");
    public static final String LIST_OF_UDT_TABLE_CREATE = "CREATE TABLE %s.%s (\n            id BIGINT PRIMARY KEY,\n            udtlist frozen<list<frozen<udt_with_collections>>>)";
    public static final QualifiedName SET_OF_UDT_SOURCE_TABLE = new QualifiedName("spark_test", "set_of_udt_src");
    public static final QualifiedName SET_OF_UDT_DEST_TABLE = new QualifiedName("spark_test", "set_of_udt_dest");
    public static final String SET_OF_UDT_TABLE_CREATE = "CREATE TABLE %s.%s (\n            id BIGINT PRIMARY KEY,\n            udtset frozen<set<frozen<udt_with_collections>>>)";
    public static final QualifiedName MAP_OF_UDT_SOURCE_TABLE = new QualifiedName("spark_test", "map_of_udt_src");
    public static final QualifiedName MAP_OF_UDT_DEST_TABLE = new QualifiedName("spark_test", "map_of_udt_dest");
    public static final String MAP_OF_UDT_TABLE_CREATE = "CREATE TABLE %s.%s (\n            id BIGINT PRIMARY KEY,\n            udtmap frozen<map<frozen<udt_with_collections>, frozen<udt_with_collections>>>)";
    public static final String UDT_WITH_LIST_OF_UDT_TYPE_NAME = "udt_with_list_of_udt_type";
    public static final String UDT_WITH_LIST_OF_UDT_TYPE_CREATE = "CREATE TYPE spark_test.udt_with_list_of_udt_type (innerudt list<frozen<two_field_udt>>);";
    public static final QualifiedName UDT_WITH_LIST_OF_UDT_SOURCE_TABLE = new QualifiedName("spark_test", "udt_with_list_of_udt_src");
    public static final QualifiedName UDT_WITH_LIST_OF_UDT_DEST_TABLE = new QualifiedName("spark_test", "udt_with_list_of_udt_dest");
    public static final String UDT_WITH_SET_OF_UDT_TYPE_NAME = "udt_with_set_of_udt_type";
    public static final String UDT_WITH_SET_OF_UDT_TYPE_CREATE = "CREATE TYPE spark_test.udt_with_set_of_udt_type (innerudt set<frozen<two_field_udt>>);";
    public static final QualifiedName UDT_WITH_SET_OF_UDT_SOURCE_TABLE = new QualifiedName("spark_test", "udt_with_set_of_udt_src");
    public static final QualifiedName UDT_WITH_SET_OF_UDT_DEST_TABLE = new QualifiedName("spark_test", "udt_with_set_of_udt_dest");
    public static final String UDT_WITH_MAP_OF_UDT_TYPE_NAME = "udt_with_map_of_udt_type";
    public static final String UDT_WITH_MAP_OF_UDT_TYPE_CREATE = "CREATE TYPE spark_test.udt_with_map_of_udt_type (innerudt map<frozen<two_field_udt>, frozen<two_field_udt>>);";
    public static final QualifiedName UDT_WITH_MAP_OF_UDT_SOURCE_TABLE = new QualifiedName("spark_test", "udt_with_map_of_udt_src");
    public static final QualifiedName UDT_WITH_MAP_OF_UDT_DEST_TABLE = new QualifiedName("spark_test", "udt_with_map_of_udt_dest");
    public static final String UDT_WITH_COLLECTION_OF_UDT_TABLE_CREATE = "CREATE TABLE %s.%s (\n            id BIGINT PRIMARY KEY,\n            outerudt frozen<%s>)";
    private ICoordinator coordinator;

    BulkWriteUdtTest() {
    }

    @Test
    void testWriteWithUdt() {
        SparkSession spark = this.getOrCreateSparkSession();
        Predicate<Integer> nullSetter = index -> index % 2 == 0;
        Dataset<org.apache.spark.sql.Row> df = DataGenerationUtils.generateUdtData(spark, 1000, nullSetter);
        this.bulkWriterDataFrameWriter(df, UDT_TABLE_NAME).save();
        SimpleQueryResult result = this.coordinator.executeWithResult("SELECT * FROM " + String.valueOf(UDT_TABLE_NAME), ConsistencyLevel.ALL, new Object[0]);
        Assertions.assertThat((boolean)result.hasNext()).isTrue();
        this.validateWritesWithDriverResultSet(df.collectAsList(), this.queryAllDataWithDriver(UDT_TABLE_NAME), BulkWriteUdtTest::udtRowFormatter);
    }

    @Test
    void testWriteWithNestedUdt() {
        SparkSession spark = this.getOrCreateSparkSession();
        Predicate<Integer> nullSetter = index -> index % 2 == 0;
        Dataset<org.apache.spark.sql.Row> df = DataGenerationUtils.generateNestedUdtData(spark, 1000, nullSetter);
        this.bulkWriterDataFrameWriter(df, NESTED_TABLE_NAME).save();
        SimpleQueryResult result = this.coordinator.executeWithResult("SELECT * FROM " + String.valueOf(NESTED_TABLE_NAME), ConsistencyLevel.ALL, new Object[0]);
        Assertions.assertThat((boolean)result.hasNext()).isTrue();
        this.validateWritesWithDriverResultSet(df.collectAsList(), this.queryAllDataWithDriver(NESTED_TABLE_NAME), BulkWriteUdtTest::udtRowFormatter);
    }

    @Test
    void testListOfUdts() {
        int numRowsInserted = this.populateListOfUdts();
        Dataset sourceData = this.bulkReaderDataFrame(LIST_OF_UDT_SOURCE_TABLE).load();
        Assertions.assertThat((long)sourceData.count()).isEqualTo((long)numRowsInserted);
        this.bulkWriterDataFrameWriter((Dataset<org.apache.spark.sql.Row>)sourceData, LIST_OF_UDT_DEST_TABLE).save();
        this.validateWritesWithDriverResultSet(sourceData.collectAsList(), this.queryAllDataWithDriver(LIST_OF_UDT_DEST_TABLE), BulkWriteUdtTest::listOfUdtRowFormatter);
    }

    private int populateListOfUdts() {
        int i;
        String insertIntoListOfUdts = "INSERT INTO %s (id, udtlist) VALUES (%d, [{f1:['value %d'], f2:{%d}, f3:{%d : 'value %d'}}])";
        for (i = 0; i < 1000; ++i) {
            this.coordinator.execute(String.format(insertIntoListOfUdts, LIST_OF_UDT_SOURCE_TABLE, i, i, i, i, i), ConsistencyLevel.ALL, new Object[0]);
        }
        this.coordinator.execute(String.format("insert into %s (id) values (%d)", LIST_OF_UDT_SOURCE_TABLE, i++), ConsistencyLevel.ALL, new Object[0]);
        this.coordinator.execute(String.format("insert into %s (id, udtlist) values (%d, null)", LIST_OF_UDT_SOURCE_TABLE, i++), ConsistencyLevel.ALL, new Object[0]);
        this.coordinator.execute(String.format("insert into %s (id, udtlist) values (%d, [{f1:null, f2:null, f3:null}])", LIST_OF_UDT_SOURCE_TABLE, i++), ConsistencyLevel.ALL, new Object[0]);
        return i;
    }

    @Test
    void testSetOfUdts() {
        int numRowsInserted = this.populateSetOfUdts();
        Dataset sourceData = this.bulkReaderDataFrame(SET_OF_UDT_SOURCE_TABLE).load();
        Assertions.assertThat((long)sourceData.count()).isEqualTo((long)numRowsInserted);
        this.bulkWriterDataFrameWriter((Dataset<org.apache.spark.sql.Row>)sourceData, SET_OF_UDT_DEST_TABLE).save();
        this.validateWritesWithDriverResultSet(sourceData.collectAsList(), this.queryAllDataWithDriver(SET_OF_UDT_DEST_TABLE), BulkWriteUdtTest::setOfUdtRowFormatter);
    }

    private int populateSetOfUdts() {
        int i;
        String insertIntoSetOfUdts = "INSERT INTO %s (id, udtset) VALUES (%d, {{f1:['value %d'], f2:{%d}, f3:{%d : 'value %d'}}})";
        for (i = 0; i < 1000; ++i) {
            this.cluster.schemaChangeIgnoringStoppedInstances(String.format(insertIntoSetOfUdts, SET_OF_UDT_SOURCE_TABLE, i, i, i, i, i));
        }
        this.coordinator.execute(String.format("insert into %s (id) values (%d)", SET_OF_UDT_SOURCE_TABLE, i++), ConsistencyLevel.ALL, new Object[0]);
        this.coordinator.execute(String.format("insert into %s (id, udtset) values (%d, null)", SET_OF_UDT_SOURCE_TABLE, i++), ConsistencyLevel.ALL, new Object[0]);
        this.coordinator.execute(String.format("insert into %s (id, udtset) values (%d, {{f1:null, f2:null, f3:null}})", SET_OF_UDT_SOURCE_TABLE, i++), ConsistencyLevel.ALL, new Object[0]);
        return i;
    }

    @Test
    void testMapOfUdts() {
        int numRowsInserted = this.populateMapOfUdts();
        Dataset sourceData = this.bulkReaderDataFrame(MAP_OF_UDT_SOURCE_TABLE).load();
        Assertions.assertThat((long)sourceData.count()).isEqualTo((long)numRowsInserted);
        this.bulkWriterDataFrameWriter((Dataset<org.apache.spark.sql.Row>)sourceData, MAP_OF_UDT_DEST_TABLE).save();
        this.validateWritesWithDriverResultSet(sourceData.collectAsList(), this.queryAllDataWithDriver(MAP_OF_UDT_DEST_TABLE), BulkWriteUdtTest::mapOfUdtRowFormatter);
    }

    private int populateMapOfUdts() {
        int i;
        String insertIntoMapOfUdts = "INSERT INTO %s (id, udtmap) VALUES (%d, {{f1:['value %d'], f2:{%d}, f3:{%d : 'value %d'}} : {f1:['value %d'], f2:{%d}, f3:{%d : 'value %d'}}})";
        for (i = 0; i < 1000; ++i) {
            this.cluster.schemaChangeIgnoringStoppedInstances(String.format(insertIntoMapOfUdts, MAP_OF_UDT_SOURCE_TABLE, i, i, i, i, i, i, i, i, i));
        }
        this.coordinator.execute(String.format("insert into %s (id) values (%d)", MAP_OF_UDT_SOURCE_TABLE, i++), ConsistencyLevel.ALL, new Object[0]);
        this.coordinator.execute(String.format("insert into %s (id, udtmap) values (%d, null)", MAP_OF_UDT_SOURCE_TABLE, i++), ConsistencyLevel.ALL, new Object[0]);
        this.coordinator.execute(String.format("insert into %s (id, udtmap) values (%d, {{f1:null, f2:null, f3:null} : {f1:null, f2:null, f3:null}})", MAP_OF_UDT_SOURCE_TABLE, i++), ConsistencyLevel.ALL, new Object[0]);
        return i;
    }

    @Test
    void testUdtWithListOfUdts() {
        int numRowsInserted = this.populateUdtWithListOfUdts();
        Dataset sourceData = this.bulkReaderDataFrame(UDT_WITH_LIST_OF_UDT_SOURCE_TABLE).load();
        Assertions.assertThat((long)sourceData.count()).isEqualTo((long)numRowsInserted);
        this.bulkWriterDataFrameWriter((Dataset<org.apache.spark.sql.Row>)sourceData, UDT_WITH_LIST_OF_UDT_DEST_TABLE).save();
        this.validateWritesWithDriverResultSet(sourceData.collectAsList(), this.queryAllDataWithDriver(UDT_WITH_LIST_OF_UDT_DEST_TABLE), BulkWriteUdtTest::udtRowFormatter);
    }

    private int populateUdtWithListOfUdts() {
        int i;
        String insertIntoUdtWithListOfUdts = "INSERT INTO %s (id, outerudt) VALUES (%d, {innerudt:[{f1:'value %d', f2:%d}]})";
        for (i = 0; i < 1000; ++i) {
            this.cluster.schemaChangeIgnoringStoppedInstances(String.format(insertIntoUdtWithListOfUdts, UDT_WITH_LIST_OF_UDT_SOURCE_TABLE, i, i, i, i, i));
        }
        this.coordinator.execute(String.format("insert into %s (id) values (%d)", UDT_WITH_LIST_OF_UDT_SOURCE_TABLE, i++), ConsistencyLevel.ALL, new Object[0]);
        this.coordinator.execute(String.format("insert into %s (id, outerudt) values (%d, null)", UDT_WITH_LIST_OF_UDT_SOURCE_TABLE, i++), ConsistencyLevel.ALL, new Object[0]);
        this.coordinator.execute(String.format("insert into %s (id, outerudt) values (%d, {innerudt:[]})", UDT_WITH_LIST_OF_UDT_SOURCE_TABLE, i++), ConsistencyLevel.ALL, new Object[0]);
        this.coordinator.execute(String.format("insert into %s (id, outerudt) values (%d, {innerudt:[{f1:null, f2:null}]})", UDT_WITH_LIST_OF_UDT_SOURCE_TABLE, i++), ConsistencyLevel.ALL, new Object[0]);
        return i;
    }

    @Test
    void testUdtWithSetOfUdts() {
        int numRowsInserted = this.populateUdtWithSetOfUdts();
        Dataset sourceData = this.bulkReaderDataFrame(UDT_WITH_SET_OF_UDT_SOURCE_TABLE).load();
        Assertions.assertThat((long)sourceData.count()).isEqualTo((long)numRowsInserted);
        this.bulkWriterDataFrameWriter((Dataset<org.apache.spark.sql.Row>)sourceData, UDT_WITH_SET_OF_UDT_DEST_TABLE).save();
        this.validateWritesWithDriverResultSet(sourceData.collectAsList(), this.queryAllDataWithDriver(UDT_WITH_SET_OF_UDT_DEST_TABLE), BulkWriteUdtTest::udtRowFormatter);
    }

    private int populateUdtWithSetOfUdts() {
        int i;
        String insertIntoUdtWithSetOfUdts = "INSERT INTO %s (id, outerudt) VALUES (%d, {innerudt:{{f1:'value %d', f2:%d}}})";
        for (i = 0; i < 1000; ++i) {
            this.cluster.schemaChangeIgnoringStoppedInstances(String.format(insertIntoUdtWithSetOfUdts, UDT_WITH_SET_OF_UDT_SOURCE_TABLE, i, i, i, i, i));
        }
        this.coordinator.execute(String.format("insert into %s (id) values (%d)", UDT_WITH_SET_OF_UDT_SOURCE_TABLE, i++), ConsistencyLevel.ALL, new Object[0]);
        this.coordinator.execute(String.format("insert into %s (id, outerudt) values (%d, null)", UDT_WITH_SET_OF_UDT_SOURCE_TABLE, i++), ConsistencyLevel.ALL, new Object[0]);
        this.coordinator.execute(String.format("insert into %s (id, outerudt) values (%d, {innerudt:{}})", UDT_WITH_SET_OF_UDT_SOURCE_TABLE, i++), ConsistencyLevel.ALL, new Object[0]);
        this.coordinator.execute(String.format("insert into %s (id, outerudt) values (%d, {innerudt:{{f1:null, f2:null}}})", UDT_WITH_SET_OF_UDT_SOURCE_TABLE, i++), ConsistencyLevel.ALL, new Object[0]);
        return i;
    }

    @Test
    void testUdtWithMapOfUdts() {
        int numRowsInserted = this.populateUdtWithMapOfUdts();
        Dataset sourceData = this.bulkReaderDataFrame(UDT_WITH_MAP_OF_UDT_SOURCE_TABLE).load();
        Assertions.assertThat((long)sourceData.count()).isEqualTo((long)numRowsInserted);
        this.bulkWriterDataFrameWriter((Dataset<org.apache.spark.sql.Row>)sourceData, UDT_WITH_MAP_OF_UDT_DEST_TABLE).save();
        this.validateWritesWithDriverResultSet(sourceData.collectAsList(), this.queryAllDataWithDriver(UDT_WITH_MAP_OF_UDT_DEST_TABLE), BulkWriteUdtTest::udtRowFormatter);
    }

    private int populateUdtWithMapOfUdts() {
        int i;
        String insertIntoUdtWithMapOfUdts = "INSERT INTO %s (id, outerudt) VALUES (%d, {innerudt:{{f1:'valueA %d', f2:%d}: {f1:'valueB %d', f2:%d}}})";
        for (i = 0; i < 1000; ++i) {
            this.cluster.schemaChangeIgnoringStoppedInstances(String.format(insertIntoUdtWithMapOfUdts, UDT_WITH_MAP_OF_UDT_SOURCE_TABLE, i, i, i, i, i));
        }
        this.coordinator.execute(String.format("insert into %s (id) values (%d)", UDT_WITH_MAP_OF_UDT_SOURCE_TABLE, i++), ConsistencyLevel.ALL, new Object[0]);
        this.coordinator.execute(String.format("insert into %s (id, outerudt) values (%d, null)", UDT_WITH_MAP_OF_UDT_SOURCE_TABLE, i++), ConsistencyLevel.ALL, new Object[0]);
        this.coordinator.execute(String.format("insert into %s (id, outerudt) values (%d, {innerudt:{{f1:null, f2:null}: {f1:null, f2:null}}})", UDT_WITH_MAP_OF_UDT_SOURCE_TABLE, i++), ConsistencyLevel.ALL, new Object[0]);
        return i;
    }

    @NotNull
    public static String udtRowFormatter(Row row) {
        UDTValue udt = row.getUDTValue(1);
        return row.getLong(0) + ":" + Objects.requireNonNullElse(udt, "null").toString().replace('[', '{').replace(']', '}');
    }

    @NotNull
    public static String listOfUdtRowFormatter(Row row) {
        return row.getLong(0) + ":" + row.getList(1, UDTValue.class).toString().replace("{}", "null").replace("[]", "null").replace('[', '{').replace(']', '}');
    }

    @NotNull
    public static String setOfUdtRowFormatter(Row row) {
        return row.getLong(0) + ":" + row.getSet(1, UDTValue.class).toString().replace("{}", "null").replace("[]", "null").replace('[', '{').replace(']', '}');
    }

    @NotNull
    public static String mapOfUdtRowFormatter(Row row) {
        return row.getLong(0) + ":" + row.getMap(1, UDTValue.class, UDTValue.class).toString().replace("{}", "null").replace("[]", "null").replace("=", ":").replace('[', '{').replace(']', '}');
    }

    protected ClusterBuilderConfiguration testClusterConfiguration() {
        return super.testClusterConfiguration().nodesPerDc(3);
    }

    protected void initializeSchemaForTest() {
        this.coordinator = this.cluster.getFirstRunningInstance().coordinator();
        this.createTestKeyspace(UDT_TABLE_NAME, TestUtils.DC1_RF3);
        this.cluster.schemaChangeIgnoringStoppedInstances(TWO_FIELD_UDT_DEF);
        this.cluster.schemaChangeIgnoringStoppedInstances(NESTED_UDT_DEF);
        this.cluster.schemaChangeIgnoringStoppedInstances(UDT_TABLE_CREATE);
        this.cluster.schemaChangeIgnoringStoppedInstances(NESTED_TABLE_CREATE);
        this.cluster.schemaChangeIgnoringStoppedInstances(UDT_WITH_COLLECTIONS_TYPE_CREATE);
        this.cluster.schemaChangeIgnoringStoppedInstances(UDT_WITH_LIST_OF_UDT_TYPE_CREATE);
        this.cluster.schemaChangeIgnoringStoppedInstances(UDT_WITH_SET_OF_UDT_TYPE_CREATE);
        this.cluster.schemaChangeIgnoringStoppedInstances(UDT_WITH_MAP_OF_UDT_TYPE_CREATE);
        this.cluster.schemaChangeIgnoringStoppedInstances(String.format(LIST_OF_UDT_TABLE_CREATE, LIST_OF_UDT_SOURCE_TABLE.keyspace(), LIST_OF_UDT_SOURCE_TABLE.table()));
        this.cluster.schemaChangeIgnoringStoppedInstances(String.format(LIST_OF_UDT_TABLE_CREATE, LIST_OF_UDT_DEST_TABLE.keyspace(), LIST_OF_UDT_DEST_TABLE.table()));
        this.cluster.schemaChangeIgnoringStoppedInstances(String.format(SET_OF_UDT_TABLE_CREATE, SET_OF_UDT_SOURCE_TABLE.keyspace(), SET_OF_UDT_SOURCE_TABLE.table()));
        this.cluster.schemaChangeIgnoringStoppedInstances(String.format(SET_OF_UDT_TABLE_CREATE, SET_OF_UDT_DEST_TABLE.keyspace(), SET_OF_UDT_DEST_TABLE.table()));
        this.cluster.schemaChangeIgnoringStoppedInstances(String.format(MAP_OF_UDT_TABLE_CREATE, MAP_OF_UDT_SOURCE_TABLE.keyspace(), MAP_OF_UDT_SOURCE_TABLE.table()));
        this.cluster.schemaChangeIgnoringStoppedInstances(String.format(MAP_OF_UDT_TABLE_CREATE, MAP_OF_UDT_DEST_TABLE.keyspace(), MAP_OF_UDT_DEST_TABLE.table()));
        this.cluster.schemaChangeIgnoringStoppedInstances(String.format(UDT_WITH_COLLECTION_OF_UDT_TABLE_CREATE, UDT_WITH_LIST_OF_UDT_SOURCE_TABLE.keyspace(), UDT_WITH_LIST_OF_UDT_SOURCE_TABLE.table(), UDT_WITH_LIST_OF_UDT_TYPE_NAME));
        this.cluster.schemaChangeIgnoringStoppedInstances(String.format(UDT_WITH_COLLECTION_OF_UDT_TABLE_CREATE, UDT_WITH_LIST_OF_UDT_DEST_TABLE.keyspace(), UDT_WITH_LIST_OF_UDT_DEST_TABLE.table(), UDT_WITH_LIST_OF_UDT_TYPE_NAME));
        this.cluster.schemaChangeIgnoringStoppedInstances(String.format(UDT_WITH_COLLECTION_OF_UDT_TABLE_CREATE, UDT_WITH_SET_OF_UDT_SOURCE_TABLE.keyspace(), UDT_WITH_SET_OF_UDT_SOURCE_TABLE.table(), UDT_WITH_SET_OF_UDT_TYPE_NAME));
        this.cluster.schemaChangeIgnoringStoppedInstances(String.format(UDT_WITH_COLLECTION_OF_UDT_TABLE_CREATE, UDT_WITH_SET_OF_UDT_DEST_TABLE.keyspace(), UDT_WITH_SET_OF_UDT_DEST_TABLE.table(), UDT_WITH_SET_OF_UDT_TYPE_NAME));
        this.cluster.schemaChangeIgnoringStoppedInstances(String.format(UDT_WITH_COLLECTION_OF_UDT_TABLE_CREATE, UDT_WITH_MAP_OF_UDT_SOURCE_TABLE.keyspace(), UDT_WITH_MAP_OF_UDT_SOURCE_TABLE.table(), UDT_WITH_MAP_OF_UDT_TYPE_NAME));
        this.cluster.schemaChangeIgnoringStoppedInstances(String.format(UDT_WITH_COLLECTION_OF_UDT_TABLE_CREATE, UDT_WITH_MAP_OF_UDT_DEST_TABLE.keyspace(), UDT_WITH_MAP_OF_UDT_DEST_TABLE.table(), UDT_WITH_MAP_OF_UDT_TYPE_NAME));
    }
}

