/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.locks.LockSupport;
import org.apache.cassandra.io.util.BufferedDataOutputStreamPlus;
import org.apache.cassandra.net.AsyncChannelPromise;
import org.apache.cassandra.net.SocketFactory;

public abstract class AsyncChannelOutputPlus
extends BufferedDataOutputStreamPlus {
    final Channel channel;
    private volatile long flushing;
    private volatile long flushed;
    private long flushedToNetwork;
    private volatile Throwable flushFailed;
    private volatile long signalWhenFlushed;
    private volatile Thread waiting;

    public AsyncChannelOutputPlus(Channel channel) {
        super(null, null);
        this.channel = channel;
    }

    protected ChannelPromise beginFlush(int byteCount, int lowWaterMark, int highWaterMark) throws IOException {
        this.waitForSpace(byteCount, lowWaterMark, highWaterMark);
        return AsyncChannelPromise.withListener(this.channel, future -> {
            if (future.isSuccess() && null == this.flushFailed) {
                this.flushedToNetwork += (long)byteCount;
                this.releaseSpace(byteCount);
            } else if (null == this.flushFailed) {
                Throwable cause = future.cause();
                if (cause == null) {
                    cause = new FlushException("Flush failed for unknown reason");
                    cause.fillInStackTrace();
                }
                this.flushFailed = cause;
                this.releaseSpace(this.flushing - this.flushed);
            } else assert (this.flushing == this.flushed);
        });
    }

    private void waitForSpace(int bytesToWrite, int lowWaterMark, int highWaterMark) throws IOException {
        int wakeUpWhenFlushing = highWaterMark - bytesToWrite;
        this.waitUntilFlushed(Math.max(lowWaterMark, wakeUpWhenFlushing), lowWaterMark);
        this.flushing += (long)bytesToWrite;
    }

    void waitUntilFlushed(int wakeUpWhenExcessBytesWritten, int signalWhenExcessBytesWritten) throws IOException {
        assert (signalWhenExcessBytesWritten <= wakeUpWhenExcessBytesWritten);
        long wakeUpWhenFlushed = this.flushing - (long)wakeUpWhenExcessBytesWritten;
        if (this.flushed < wakeUpWhenFlushed) {
            this.parkUntilFlushed(wakeUpWhenFlushed, this.flushing - (long)signalWhenExcessBytesWritten);
        }
        this.propagateFailedFlush();
    }

    protected void parkUntilFlushed(long wakeUpWhenFlushed, long signalWhenFlushed) {
        assert (wakeUpWhenFlushed <= signalWhenFlushed);
        assert (this.waiting == null);
        this.waiting = Thread.currentThread();
        this.signalWhenFlushed = signalWhenFlushed;
        while (this.flushed < wakeUpWhenFlushed) {
            LockSupport.park();
        }
        this.waiting = null;
    }

    protected void releaseSpace(long bytesFlushed) {
        long newFlushed;
        this.flushed = newFlushed = this.flushed + bytesFlushed;
        Thread thread = this.waiting;
        if (thread != null && this.signalWhenFlushed <= newFlushed) {
            LockSupport.unpark(thread);
        }
    }

    private void propagateFailedFlush() throws IOException {
        Throwable t = this.flushFailed;
        if (t != null) {
            if (SocketFactory.isCausedByConnectionReset(t)) {
                throw new FlushException("The channel this output stream was writing to has been closed", t);
            }
            throw new FlushException("This output stream is in an unsafe state after an asynchronous flush failed", t);
        }
    }

    @Override
    protected abstract void doFlush(int var1) throws IOException;

    @Override
    public abstract long position();

    public long flushed() {
        return this.flushing;
    }

    public long flushedToNetwork() {
        return this.flushedToNetwork;
    }

    @Override
    public void flush() throws IOException {
        this.doFlush(0);
        this.waitUntilFlushed(0, 0);
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.discard();
        }
    }

    public abstract void discard();

    @Override
    protected WritableByteChannel newDefaultChannel() {
        throw new UnsupportedOperationException();
    }

    public static class FlushException
    extends IOException {
        public FlushException(String message) {
            super(message);
        }

        public FlushException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

