/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.algo.graph;

import java.util.Comparator;
import org.psjava.algo.graph.LowestCommonAncestorQuerySession;
import org.psjava.algo.graph.dfs.DFSVisitorBase;
import org.psjava.algo.graph.dfs.SingleSourceDFS;
import org.psjava.algo.sequence.rmq.RangeMinimumQuery;
import org.psjava.algo.sequence.rmq.RangeMinimumQuerySession;
import org.psjava.ds.array.DynamicArray;
import org.psjava.ds.array.LastInArray;
import org.psjava.ds.graph.DirectedEdge;
import org.psjava.ds.graph.RootedTree;
import org.psjava.ds.map.MutableMap;
import org.psjava.ds.map.MutableMapFactory;
import org.psjava.util.VisitorStopper;

public class LowestCommonAncestorAlgorithm {
    private MutableMapFactory mapFactory;
    private RangeMinimumQuery rmq;

    public LowestCommonAncestorAlgorithm(RangeMinimumQuery rmq, MutableMapFactory mapFactory) {
        this.rmq = rmq;
        this.mapFactory = mapFactory;
    }

    public <V, E extends DirectedEdge<V>> LowestCommonAncestorQuerySession<V> calc(RootedTree<V, E> tree) {
        final MutableMap discoverIndex = this.mapFactory.create();
        final DynamicArray history = DynamicArray.create();
        SingleSourceDFS.traverse(tree.graph, tree.root, new DFSVisitorBase<V, E>(){

            @Override
            public void onDiscovered(V vertex, int depth, VisitorStopper stopper) {
                discoverIndex.add(vertex, history.size());
                history.addToLast(new VertexAndDepth(vertex, depth));
            }

            @Override
            public void onWalkUp(E downedEdge) {
                int lastDepth = ((VertexAndDepth)LastInArray.getLast(history)).depth;
                history.addToLast(new VertexAndDepth(downedEdge.from(), lastDepth - 1));
            }
        });
        final RangeMinimumQuerySession rmqSession = this.rmq.preprocess(history, new Comparator<VertexAndDepth<V>>(){

            @Override
            public int compare(VertexAndDepth<V> o1, VertexAndDepth<V> o2) {
                return o1.depth - o2.depth;
            }
        });
        return new LowestCommonAncestorQuerySession<V>(){

            @Override
            public V query(V v1, V v2) {
                int i1 = (Integer)discoverIndex.get(v1);
                int i2 = (Integer)discoverIndex.get(v2);
                return ((VertexAndDepth)history.get((int)rmqSession.getIndex((int)Math.min((int)i1, (int)i2), (int)(Math.max((int)i1, (int)i2) + 1)))).vertex;
            }
        };
    }

    private static class VertexAndDepth<V> {
        final V vertex;
        final int depth;

        VertexAndDepth(V v, int d) {
            this.vertex = v;
            this.depth = d;
        }
    }
}

