/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Output;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CdcBridge;
import org.apache.cassandra.bridge.CdcBridgeFactory;
import org.apache.cassandra.bridge.TokenRange;
import org.apache.cassandra.cdc.CdcBuilder;
import org.apache.cassandra.cdc.CdcKryoRegister;
import org.apache.cassandra.cdc.MicroBatchIterator;
import org.apache.cassandra.cdc.api.CassandraSource;
import org.apache.cassandra.cdc.api.CdcOptions;
import org.apache.cassandra.cdc.api.CommitLogMarkers;
import org.apache.cassandra.cdc.api.CommitLogProvider;
import org.apache.cassandra.cdc.api.EventConsumer;
import org.apache.cassandra.cdc.api.SchemaSupplier;
import org.apache.cassandra.cdc.api.StatePersister;
import org.apache.cassandra.cdc.api.TableIdLookup;
import org.apache.cassandra.cdc.api.TokenRangeSupplier;
import org.apache.cassandra.cdc.msg.CdcEvent;
import org.apache.cassandra.cdc.state.CdcState;
import org.apache.cassandra.cdc.stats.ICdcStats;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.partitioner.NotEnoughReplicasException;
import org.apache.cassandra.spark.utils.AsyncExecutor;
import org.apache.cassandra.spark.utils.KryoUtils;
import org.apache.cassandra.spark.utils.ThrowableUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cdc
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Cdc.class);
    @NotNull
    private final String jobId;
    private final int partitionId;
    private final TokenRangeSupplier tokenRangeSupplier;
    private final TableIdLookup tableIdLookup;
    protected final SchemaSupplier schemaSupplier;
    private final CassandraSource cassandraSource;
    private final StatePersister statePersister;
    private final CdcOptions cdcOptions;
    protected final AsyncExecutor asyncExecutor;
    protected final CommitLogProvider commitLogProvider;
    private final ICdcStats stats;
    private final EventConsumer eventConsumer;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final AtomicReference<CompletableFuture<Void>> active = new AtomicReference<Object>(null);
    private volatile CdcState currentState = null;
    protected volatile long batchStartNanos;
    protected volatile Set<CqlTable> cdcEnabledTables = Collections.emptySet();

    protected Cdc(@NotNull CdcBuilder builder) {
        this.jobId = builder.jobId;
        this.partitionId = builder.partitionId;
        this.tokenRangeSupplier = builder.tokenRangeSupplier;
        this.tableIdLookup = builder.tableIdLookup;
        this.schemaSupplier = builder.schemaSupplier;
        this.cassandraSource = builder.cassandraSource;
        this.statePersister = builder.statePersister;
        this.cdcOptions = builder.cdcOptions;
        this.asyncExecutor = builder.asyncExecutor;
        this.commitLogProvider = builder.commitLogProvider;
        this.stats = builder.stats;
        this.eventConsumer = builder.eventConsumer;
    }

    public static CdcBuilder builder(@NotNull String jobId, int partitionId, EventConsumer eventConsumer, SchemaSupplier schemaSupplier) {
        return new CdcBuilder(jobId, partitionId, eventConsumer, schemaSupplier);
    }

    public String jobId() {
        return this.jobId;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public long epoch() {
        return this.currentState.epoch;
    }

    @NotNull
    public CommitLogMarkers markers() {
        return this.currentState.markers;
    }

    public void start() {
        TokenRange tokenRange = (TokenRange)this.tokenRangeSupplier.get();
        this.currentState = this.statePersister.loadCanonicalState(this.jobId, this.partitionId, tokenRange);
        if (!this.isRunning.get() && this.isRunning.compareAndSet(false, true)) {
            LOGGER.info("Starting CDC Consumer jobId={} partitionId={} lower={} upper={}", new Object[]{this.jobId, this.partitionId, tokenRange == null ? null : tokenRange.lowerEndpoint(), tokenRange == null ? null : tokenRange.upperEndpoint()});
            this.refreshSchema();
            this.scheduleRun(0L);
            this.scheduleMonitorSchema();
        }
    }

    public void stop() {
        try {
            this.stop(true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOGGER.error("Failed to stop CDC consumer cleanly", ThrowableUtils.rootCause((Throwable)e));
        }
    }

    public void stop(boolean blocking) throws ExecutionException, InterruptedException {
        if (this.isRunning.get() && this.isRunning.compareAndSet(true, false)) {
            LOGGER.info("Stopping CDC Consumer jobId={} partitionId={}", (Object)this.jobId, (Object)this.partitionId);
            CompletableFuture<Void> activeFuture = this.active.get();
            if (activeFuture != null && blocking) {
                long timeout = this.cdcOptions.stopTimeout().toMillis();
                try {
                    activeFuture.get(timeout, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    LOGGER.warn("Failed to cleanly shutdown active future after {} millis", (Object)timeout);
                    this.stats.cdcConsumerStopTimeout();
                }
            }
            LOGGER.info("Stopped CDC Consumer jobId={} partitionId={}", (Object)this.jobId, (Object)this.partitionId);
        }
    }

    protected void scheduleNextRun() {
        this.scheduleRun(this.cdcOptions.nextDelayMillis(this.batchStartNanos));
    }

    protected void scheduleRun(long delayMillis) {
        if (!this.isRunning.get() || this.isFinished()) {
            return;
        }
        this.active.getAndUpdate(curr -> {
            if (curr == null) {
                CompletableFuture future = new CompletableFuture();
                if (delayMillis <= 0L) {
                    this.asyncExecutor.submit(() -> this.runSafe(future));
                } else {
                    this.asyncExecutor.schedule(() -> this.runSafe(future), delayMillis);
                }
                return future;
            }
            return curr;
        });
    }

    protected void completeActiveFuture(CompletableFuture<Void> future) {
        if (this.active.compareAndSet(future, null)) {
            future.complete(null);
        }
    }

    protected void runSafe(CompletableFuture<Void> future) {
        try {
            this.run();
            this.completeActiveFuture(future);
            this.scheduleNextRun();
        }
        catch (NotEnoughReplicasException e) {
            this.completeActiveFuture(future);
            this.scheduleRun(this.cdcOptions.sleepWhenInsufficientReplicas().toMillis());
        }
        catch (Throwable t) {
            this.completeActiveFuture(future);
            if (this.handleError(t)) {
                LOGGER.warn("CdcConsumer epoch failed with recoverable error, scheduling next run jobId={} partition={} epoch={}", new Object[]{this.jobId, this.partitionId, this.currentState.epoch, t});
                this.scheduleNextRun();
            }
            LOGGER.error("CdcConsumer epoch failed with unrecoverable error jobId={} partition={} epoch={}", new Object[]{this.jobId, this.partitionId, this.currentState.epoch, t});
            this.stop();
        }
    }

    protected boolean handleError(Throwable t) {
        LOGGER.error("Unexpected error in CdcConsumer", t);
        return true;
    }

    protected MicroBatchIterator newMicroBatchIterator() throws NotEnoughReplicasException {
        return this.newMicroBatchIterator(null, this.currentState);
    }

    protected MicroBatchIterator newMicroBatchIterator(@Nullable TokenRange tokenRange, CdcState startState) throws NotEnoughReplicasException {
        return new MicroBatchIterator(this.cdcBridge(), this.partitionId, tokenRange, startState, this.cassandraSource, this::keyspaceSupplier, this.cdcOptions, this.asyncExecutor, this.commitLogProvider, this.stats);
    }

    protected Set<String> keyspaceSupplier() {
        return this.cdcEnabledTables.stream().map(CqlTable::keyspace).collect(Collectors.toSet());
    }

    protected void run() throws NotEnoughReplicasException {
        this.batchStartNanos = System.nanoTime();
        TokenRange tokenRange = (TokenRange)this.tokenRangeSupplier.get();
        CdcState startState = this.currentState.purgeIfFull(this.stats, this.cdcOptions);
        try (MicroBatchIterator it = this.newMicroBatchIterator(tokenRange, startState);){
            while (it.hasNext()) {
                CdcEvent event = it.next();
                this.eventConsumer.accept(event);
            }
            CdcState endState = it.endState();
            this.persist(endState, tokenRange);
            this.currentState = endState;
        }
    }

    protected boolean isFinished() {
        return !this.cdcOptions.isRunning() || this.epochsExceeded();
    }

    protected boolean epochsExceeded() {
        int maxEpochs = this.cdcOptions.maxEpochs();
        return maxEpochs > 0 && this.currentState.epoch >= (long)maxEpochs;
    }

    protected CassandraBridge bridge() {
        return CdcBridgeFactory.get(this.cdcOptions.version());
    }

    protected CdcBridge cdcBridge() {
        return CdcBridgeFactory.getCdcBridge(this.cdcOptions.version());
    }

    public ByteBuffer serializeStateToBytes() throws IOException {
        try (Output out = KryoUtils.serialize((Kryo)CdcKryoRegister.kryo(), (Object)this.currentState, (Serializer)CdcState.SERIALIZER);){
            ByteBuffer byteBuffer = this.bridge().compressionUtil().compress(out.getBuffer());
            return byteBuffer;
        }
    }

    protected void persist(CdcState cdcState, TokenRange tokenRange) {
        if (!this.cdcOptions.persistState()) {
            return;
        }
        try {
            ByteBuffer buf = this.serializeStateToBytes();
            LOGGER.debug("Persisting Iterator state between micro-batch partitionId={} epoch={} size={}", new Object[]{this.partitionId, cdcState.epoch, buf.remaining()});
            this.statePersister.persist(this.jobId, this.partitionId, tokenRange, buf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void scheduleMonitorSchema() {
        long delayMillis = this.cdcOptions.schemaRefreshDelay().toMillis();
        if (delayMillis > 0L) {
            this.asyncExecutor.schedule(this::refreshSchema, delayMillis);
        }
    }

    protected void refreshSchema() {
        if (!this.isRunning.get()) {
            return;
        }
        try {
            ((CompletableFuture)this.schemaSupplier.getCdcEnabledTables().handle((tables, throwable) -> {
                if (throwable != null) {
                    LOGGER.warn("Error refreshing schema", throwable);
                    return null;
                }
                this.cdcEnabledTables = tables;
                if (tables == null || tables.isEmpty()) {
                    LOGGER.warn("No CQL enabled tables");
                    return null;
                }
                this.cdcBridge().updateCdcSchema(tables, this.cdcOptions.partitioner(), this.tableIdLookup);
                return null;
            })).whenComplete((aVoid, throwable) -> {
                if (throwable != null) {
                    LOGGER.error("Unexpected error refreshing schema", throwable);
                }
                this.scheduleMonitorSchema();
            });
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error refreshing schema", (Throwable)e);
            this.scheduleMonitorSchema();
        }
    }

    @Override
    public void close() {
        this.stop();
    }
}

