/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.secrets;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.cassandra.spark.utils.MapUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslConfig
implements Serializable {
    private static final long serialVersionUID = -3844712192096436932L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SslConfig.class);
    public static final String SECRETS_PATH = "SECRETS_PATH";
    public static final String KEYSTORE_PATH = "KEYSTORE_PATH";
    public static final String KEYSTORE_BASE64_ENCODED = "KEYSTORE_BASE64_ENCODED";
    public static final String KEYSTORE_PASSWORD = "KEYSTORE_PASSWORD";
    public static final String KEYSTORE_TYPE = "KEYSTORE_TYPE";
    public static final String DEFAULT_KEYSTORE_TYPE = "PKCS12";
    public static final String TRUSTSTORE_PATH = "TRUSTSTORE_PATH";
    public static final String TRUSTSTORE_BASE64_ENCODED = "TRUSTSTORE_BASE64_ENCODED";
    public static final String TRUSTSTORE_PASSWORD = "TRUSTSTORE_PASSWORD";
    public static final String TRUSTSTORE_TYPE = "TRUSTSTORE_TYPE";
    public static final String DEFAULT_TRUSTSTORE_TYPE = "JKS";
    protected String secretsPath;
    protected String keyStorePath;
    protected String base64EncodedKeyStore;
    protected String keyStorePassword;
    protected String keyStoreType;
    protected String trustStorePath;
    protected String base64EncodedTrustStore;
    protected String trustStorePassword;
    protected String trustStoreType;

    protected SslConfig(Builder<?> builder) {
        this.secretsPath = builder.secretsPath;
        this.keyStorePath = builder.keyStorePath;
        this.base64EncodedKeyStore = builder.base64EncodedKeyStore;
        this.keyStorePassword = builder.keyStorePassword;
        this.keyStoreType = builder.keyStoreType;
        this.trustStorePath = builder.trustStorePath;
        this.base64EncodedTrustStore = builder.base64EncodedTrustStore;
        this.trustStorePassword = builder.trustStorePassword;
        this.trustStoreType = builder.trustStoreType;
    }

    public String secretsPath() {
        return this.secretsPath;
    }

    public String keyStorePath() {
        return this.keyStorePath;
    }

    public String base64EncodedKeyStore() {
        return this.base64EncodedKeyStore;
    }

    public String keyStorePassword() {
        return this.keyStorePassword;
    }

    public String keyStoreType() {
        return this.keyStoreType != null ? this.keyStoreType : DEFAULT_KEYSTORE_TYPE;
    }

    public String trustStorePath() {
        return this.trustStorePath;
    }

    public String base64EncodedTrustStore() {
        return this.base64EncodedTrustStore;
    }

    public String trustStorePassword() {
        return this.trustStorePassword;
    }

    public String trustStoreType() {
        return this.trustStoreType != null ? this.trustStoreType : DEFAULT_TRUSTSTORE_TYPE;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        LOGGER.debug("Falling back to JDK deserialization");
        this.secretsPath = this.readNullableString(in);
        this.keyStorePath = this.readNullableString(in);
        this.base64EncodedKeyStore = this.readNullableString(in);
        this.keyStorePassword = this.readNullableString(in);
        this.keyStoreType = this.readNullableString(in);
        this.trustStorePath = this.readNullableString(in);
        this.base64EncodedTrustStore = this.readNullableString(in);
        this.trustStorePassword = this.readNullableString(in);
        this.trustStoreType = this.readNullableString(in);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        LOGGER.debug("Falling back to JDK serialization");
        this.writeNullableString(out, this.secretsPath);
        this.writeNullableString(out, this.keyStorePath);
        this.writeNullableString(out, this.base64EncodedKeyStore);
        this.writeNullableString(out, this.keyStorePassword);
        this.writeNullableString(out, this.keyStoreType);
        this.writeNullableString(out, this.trustStorePath);
        this.writeNullableString(out, this.base64EncodedTrustStore);
        this.writeNullableString(out, this.trustStorePassword);
        this.writeNullableString(out, this.trustStoreType);
    }

    private String readNullableString(ObjectInputStream in) throws IOException {
        return in.readBoolean() ? in.readUTF() : null;
    }

    private void writeNullableString(ObjectOutputStream out, String string) throws IOException {
        if (string != null) {
            out.writeBoolean(true);
            out.writeUTF(string);
        } else {
            out.writeBoolean(false);
        }
    }

    @Nullable
    public static SslConfig create(Map<String, String> options) {
        String secretsPath = MapUtils.getOrDefault(options, SECRETS_PATH, null);
        String keyStorePath = MapUtils.getOrDefault(options, KEYSTORE_PATH, null);
        String encodedKeyStore = MapUtils.getOrDefault(options, KEYSTORE_BASE64_ENCODED, null);
        String keyStorePassword = MapUtils.getOrDefault(options, KEYSTORE_PASSWORD, null);
        String keyStoreType = MapUtils.getOrDefault(options, KEYSTORE_TYPE, null);
        String trustStorePath = MapUtils.getOrDefault(options, TRUSTSTORE_PATH, null);
        String encodedTrustStore = MapUtils.getOrDefault(options, TRUSTSTORE_BASE64_ENCODED, null);
        String trustStorePassword = MapUtils.getOrDefault(options, TRUSTSTORE_PASSWORD, null);
        String trustStoreType = MapUtils.getOrDefault(options, TRUSTSTORE_TYPE, null);
        if (secretsPath != null || keyStorePath != null || encodedKeyStore != null || keyStorePassword != null || keyStoreType != null || trustStorePath != null || encodedTrustStore != null || trustStorePassword != null || trustStoreType != null) {
            Object validatedConfig = ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().secretsPath(secretsPath)).keyStorePath(keyStorePath)).base64EncodedKeyStore(encodedKeyStore)).keyStorePassword(keyStorePassword)).keyStoreType(keyStoreType)).trustStorePath(trustStorePath)).base64EncodedTrustStore(encodedTrustStore)).trustStorePassword(trustStorePassword)).trustStoreType(trustStoreType)).validate();
            LOGGER.info("Valid SSL configuration");
            return ((Builder)validatedConfig).build();
        }
        LOGGER.warn("No SSL configured");
        return null;
    }

    public static class Builder<T extends Builder<T>> {
        protected String secretsPath;
        protected String keyStorePath;
        protected String base64EncodedKeyStore;
        protected String keyStorePassword;
        protected String keyStoreType;
        protected String trustStorePath;
        protected String base64EncodedTrustStore;
        protected String trustStorePassword;
        protected String trustStoreType;

        protected T self() {
            return (T)this;
        }

        public T secretsPath(String secretsPath) {
            this.secretsPath = secretsPath;
            return this.self();
        }

        public T keyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this.self();
        }

        public T base64EncodedKeyStore(String base64EncodedKeyStore) {
            this.base64EncodedKeyStore = base64EncodedKeyStore;
            return this.self();
        }

        public T keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this.self();
        }

        public T keyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
            return this.self();
        }

        public T trustStorePath(String trustStorePath) {
            this.trustStorePath = trustStorePath;
            return this.self();
        }

        public T base64EncodedTrustStore(String base64EncodedTrustStore) {
            this.base64EncodedTrustStore = base64EncodedTrustStore;
            return this.self();
        }

        public T trustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this.self();
        }

        public T trustStoreType(String trustStoreType) {
            this.trustStoreType = trustStoreType;
            return this.self();
        }

        public SslConfig build() {
            return new SslConfig(this);
        }

        protected T validate() {
            if (this.keyStorePath != null && this.base64EncodedKeyStore != null) {
                throw new IllegalArgumentException(String.format("Both '%s' and '%s' options were provided. Only one of the options can be provided", SslConfig.KEYSTORE_PATH, SslConfig.KEYSTORE_BASE64_ENCODED));
            }
            if (this.keyStorePassword != null) {
                if (this.keyStorePath == null && this.base64EncodedKeyStore == null) {
                    throw new IllegalArgumentException(String.format("One of the '%s' or '%s' options must be provided when the '%s' option is provided", SslConfig.KEYSTORE_PATH, SslConfig.KEYSTORE_BASE64_ENCODED, SslConfig.KEYSTORE_PASSWORD));
                }
            } else {
                throw new IllegalArgumentException(String.format("The '%s' option must be provided when either the '%s' or '%s' options are provided", SslConfig.KEYSTORE_PASSWORD, SslConfig.KEYSTORE_PATH, SslConfig.KEYSTORE_BASE64_ENCODED));
            }
            if (this.trustStorePassword != null) {
                if (this.trustStorePath != null && this.base64EncodedTrustStore != null) {
                    throw new IllegalArgumentException(String.format("Both '%s' and '%s' options were provided. Only one of the options can be provided", SslConfig.TRUSTSTORE_PATH, SslConfig.TRUSTSTORE_BASE64_ENCODED));
                }
                if (this.trustStorePath == null && this.base64EncodedTrustStore == null) {
                    throw new IllegalArgumentException(String.format("One of the '%s' or '%s' options must be provided when the '%s' option is provided", SslConfig.TRUSTSTORE_PATH, SslConfig.TRUSTSTORE_BASE64_ENCODED, SslConfig.TRUSTSTORE_PASSWORD));
                }
            } else if (this.trustStorePath != null || this.base64EncodedTrustStore != null) {
                throw new IllegalArgumentException(String.format("The '%s' option must be provided when either the '%s' or '%s' options are provided", SslConfig.TRUSTSTORE_PASSWORD, SslConfig.TRUSTSTORE_PATH, SslConfig.TRUSTSTORE_BASE64_ENCODED));
            }
            return this.self();
        }
    }

    public static class Serializer
    extends com.esotericsoftware.kryo.Serializer<SslConfig> {
        public SslConfig read(Kryo kryo, Input in, Class type) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().secretsPath(in.readString())).keyStorePath(in.readString())).base64EncodedKeyStore(in.readString())).keyStorePassword(in.readString())).keyStoreType(in.readString())).trustStorePath(in.readString())).base64EncodedTrustStore(in.readString())).trustStorePassword(in.readString())).trustStoreType(in.readString())).build();
        }

        public void write(Kryo kryo, Output out, SslConfig config) {
            out.writeString(config.secretsPath);
            out.writeString(config.keyStorePath);
            out.writeString(config.base64EncodedKeyStore);
            out.writeString(config.keyStorePassword);
            out.writeString(config.keyStoreType);
            out.writeString(config.trustStorePath);
            out.writeString(config.base64EncodedTrustStore);
            out.writeString(config.trustStorePassword);
            out.writeString(config.trustStoreType);
        }
    }
}

