/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.http.impl;

import o.a.c.sidecar.client.shaded.io.netty.handler.codec.http.cookie.DefaultCookie;
import o.a.c.sidecar.client.shaded.io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.Cookie;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.CookieSameSite;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.impl.ServerCookie;

public class CookieImpl
implements ServerCookie {
    private final o.a.c.sidecar.client.shaded.io.netty.handler.codec.http.cookie.Cookie nettyCookie;
    private final boolean fromUserAgent;
    private boolean changed;
    private CookieSameSite sameSite;

    public CookieImpl(String name, String value) {
        this.nettyCookie = new DefaultCookie(name, value);
        this.fromUserAgent = false;
        this.changed = true;
    }

    CookieImpl(o.a.c.sidecar.client.shaded.io.netty.handler.codec.http.cookie.Cookie nettyCookie) {
        this.nettyCookie = nettyCookie;
        this.fromUserAgent = true;
    }

    @Override
    public String getValue() {
        return this.nettyCookie.value();
    }

    @Override
    public Cookie setValue(String value) {
        this.nettyCookie.setValue(value);
        this.changed = true;
        return this;
    }

    @Override
    public String getName() {
        return this.nettyCookie.name();
    }

    @Override
    public Cookie setDomain(String domain) {
        this.nettyCookie.setDomain(domain);
        this.changed = true;
        return this;
    }

    @Override
    public String getDomain() {
        return this.nettyCookie.domain();
    }

    @Override
    public Cookie setPath(String path) {
        this.nettyCookie.setPath(path);
        this.changed = true;
        return this;
    }

    @Override
    public String getPath() {
        return this.nettyCookie.path();
    }

    @Override
    public Cookie setMaxAge(long maxAge) {
        this.nettyCookie.setMaxAge(maxAge);
        this.changed = true;
        return this;
    }

    @Override
    public long getMaxAge() {
        return this.nettyCookie.maxAge();
    }

    @Override
    public Cookie setSecure(boolean secure) {
        this.nettyCookie.setSecure(secure);
        this.changed = true;
        return this;
    }

    @Override
    public boolean isSecure() {
        return this.nettyCookie.isSecure();
    }

    @Override
    public Cookie setHttpOnly(boolean httpOnly) {
        this.nettyCookie.setHttpOnly(httpOnly);
        this.changed = true;
        return this;
    }

    @Override
    public boolean isHttpOnly() {
        return this.nettyCookie.isHttpOnly();
    }

    @Override
    public Cookie setSameSite(CookieSameSite sameSite) {
        this.sameSite = sameSite;
        this.changed = true;
        return this;
    }

    @Override
    public CookieSameSite getSameSite() {
        return this.sameSite;
    }

    @Override
    public String encode() {
        if (this.sameSite != null) {
            return ServerCookieEncoder.STRICT.encode(this.nettyCookie) + "; SameSite=" + this.sameSite.toString();
        }
        return ServerCookieEncoder.STRICT.encode(this.nettyCookie);
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    @Override
    public boolean isFromUserAgent() {
        return this.fromUserAgent;
    }
}

