/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.impl.transports;

import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import o.a.c.sidecar.client.shaded.io.netty.bootstrap.ServerBootstrap;
import o.a.c.sidecar.client.shaded.io.netty.channel.Channel;
import o.a.c.sidecar.client.shaded.io.netty.channel.ChannelFactory;
import o.a.c.sidecar.client.shaded.io.netty.channel.EventLoopGroup;
import o.a.c.sidecar.client.shaded.io.netty.channel.ServerChannel;
import o.a.c.sidecar.client.shaded.io.netty.channel.kqueue.KQueue;
import o.a.c.sidecar.client.shaded.io.netty.channel.kqueue.KQueueChannelOption;
import o.a.c.sidecar.client.shaded.io.netty.channel.kqueue.KQueueDatagramChannel;
import o.a.c.sidecar.client.shaded.io.netty.channel.kqueue.KQueueDomainSocketChannel;
import o.a.c.sidecar.client.shaded.io.netty.channel.kqueue.KQueueEventLoopGroup;
import o.a.c.sidecar.client.shaded.io.netty.channel.kqueue.KQueueServerDomainSocketChannel;
import o.a.c.sidecar.client.shaded.io.netty.channel.kqueue.KQueueServerSocketChannel;
import o.a.c.sidecar.client.shaded.io.netty.channel.kqueue.KQueueSocketChannel;
import o.a.c.sidecar.client.shaded.io.netty.channel.socket.DatagramChannel;
import o.a.c.sidecar.client.shaded.io.netty.channel.socket.InternetProtocolFamily;
import o.a.c.sidecar.client.shaded.io.netty.channel.unix.DomainSocketAddress;
import o.a.c.sidecar.client.shaded.io.vertx.core.datagram.DatagramSocketOptions;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.NetServerOptions;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.impl.SocketAddressImpl;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.transport.Transport;

public class KQueueTransport
implements Transport {
    @Override
    public boolean supportsDomainSockets() {
        return true;
    }

    @Override
    public SocketAddress convert(o.a.c.sidecar.client.shaded.io.vertx.core.net.SocketAddress address) {
        if (address.isDomainSocket()) {
            return new DomainSocketAddress(address.path());
        }
        return Transport.super.convert(address);
    }

    @Override
    public o.a.c.sidecar.client.shaded.io.vertx.core.net.SocketAddress convert(SocketAddress address) {
        if (address instanceof DomainSocketAddress) {
            return new SocketAddressImpl(((DomainSocketAddress)address).path());
        }
        return Transport.super.convert(address);
    }

    @Override
    public boolean isAvailable() {
        return KQueue.isAvailable();
    }

    @Override
    public Throwable unavailabilityCause() {
        return KQueue.unavailabilityCause();
    }

    @Override
    public EventLoopGroup eventLoopGroup(int type, int nThreads, ThreadFactory threadFactory, int ioRatio) {
        KQueueEventLoopGroup eventLoopGroup = new KQueueEventLoopGroup(nThreads, threadFactory);
        eventLoopGroup.setIoRatio(ioRatio);
        return eventLoopGroup;
    }

    @Override
    public DatagramChannel datagramChannel() {
        return new KQueueDatagramChannel();
    }

    @Override
    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        return new KQueueDatagramChannel();
    }

    @Override
    public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
        if (domainSocket) {
            return KQueueDomainSocketChannel::new;
        }
        return KQueueSocketChannel::new;
    }

    @Override
    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
        if (domainSocket) {
            return KQueueServerDomainSocketChannel::new;
        }
        return KQueueServerSocketChannel::new;
    }

    @Override
    public void configure(NetServerOptions options, boolean domainSocket, ServerBootstrap bootstrap) {
        if (!domainSocket) {
            bootstrap.option(KQueueChannelOption.SO_REUSEPORT, options.isReusePort());
        }
        Transport.super.configure(options, domainSocket, bootstrap);
    }

    @Override
    public void configure(DatagramChannel channel, DatagramSocketOptions options) {
        channel.config().setOption(KQueueChannelOption.SO_REUSEPORT, options.isReusePort());
        Transport.super.configure(channel, options);
    }
}

