/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import org.apache.commons.numbers.core.Sum;
import org.apache.commons.statistics.descriptive.DoubleStatistic;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;
import org.apache.commons.statistics.descriptive.Statistics;

public final class SumOfLogs
implements DoubleStatistic,
StatisticAccumulator<SumOfLogs> {
    private final Sum delegate = Sum.create();

    private SumOfLogs() {
    }

    public static SumOfLogs create() {
        return new SumOfLogs();
    }

    public static SumOfLogs of(double ... values) {
        return Statistics.add(new SumOfLogs(), values);
    }

    public static SumOfLogs ofRange(double[] values, int from, int to) {
        Statistics.checkFromToIndex(from, to, values.length);
        return SumOfLogs.createFromRange(values, from, to);
    }

    static SumOfLogs createFromRange(double[] values, int from, int to) {
        return Statistics.add(new SumOfLogs(), values, from, to);
    }

    public static SumOfLogs of(int ... values) {
        return Statistics.add(new SumOfLogs(), values);
    }

    public static SumOfLogs ofRange(int[] values, int from, int to) {
        Statistics.checkFromToIndex(from, to, values.length);
        return SumOfLogs.createFromRange(values, from, to);
    }

    static SumOfLogs createFromRange(int[] values, int from, int to) {
        return Statistics.add(new SumOfLogs(), values, from, to);
    }

    public static SumOfLogs of(long ... values) {
        return Statistics.add(new SumOfLogs(), values);
    }

    public static SumOfLogs ofRange(long[] values, int from, int to) {
        Statistics.checkFromToIndex(from, to, values.length);
        return SumOfLogs.createFromRange(values, from, to);
    }

    static SumOfLogs createFromRange(long[] values, int from, int to) {
        return Statistics.add(new SumOfLogs(), values, from, to);
    }

    @Override
    public void accept(double value) {
        this.delegate.accept(Math.log(value));
    }

    @Override
    public double getAsDouble() {
        return this.delegate.getAsDouble();
    }

    @Override
    public SumOfLogs combine(SumOfLogs other) {
        this.delegate.add(other.delegate);
        return this;
    }
}

