/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Indentable;
import org.apache.daffodil.lib.util.MStackOf;
import org.apache.daffodil.lib.util.MStackOfBoolean;
import org.apache.daffodil.lib.util.MStackOfBoolean$;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.apache.daffodil.runtime1.processors.DaffodilParseOutputStreamContentHandler$;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;
import scala.xml.NamespaceBinding;
import scala.xml.NamespaceBinding$;
import scala.xml.Utility$;

public class DaffodilParseOutputStreamContentHandler
implements ContentHandler,
Indentable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DaffodilParseOutputStreamContentHandler.class.getDeclaredField("activePrefixMappingContextStack$lzy1"));
    private int indentSize;
    private char indentChar;
    private String org$apache$daffodil$lib$util$Indentable$$indentString;
    private int org$apache$daffodil$lib$util$Indentable$$indentLength;
    private final OutputStream out;
    private final boolean pretty;
    private final OutputStreamWriter writer;
    private NamespaceBinding activePrefixMapping;
    private NamespaceBinding currentElementPrefixMapping;
    private volatile Object activePrefixMappingContextStack$lzy1;
    private final MStackOfBoolean outputNewlineStack;

    public static boolean $lessinit$greater$default$2() {
        return DaffodilParseOutputStreamContentHandler$.MODULE$.$lessinit$greater$default$2();
    }

    /*
     * WARNING - void declaration
     */
    public DaffodilParseOutputStreamContentHandler(OutputStream out, boolean pretty) {
        void var3_3;
        this.out = out;
        this.pretty = pretty;
        Indentable.$init$(this);
        this.writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        this.activePrefixMapping = null;
        this.currentElementPrefixMapping = null;
        MStackOfBoolean s = MStackOfBoolean$.MODULE$.apply();
        s.push(BoxesRunTime.boxToBoolean((boolean)false));
        this.outputNewlineStack = var3_3;
        Statics.releaseFence();
    }

    @Override
    public int indentSize() {
        return this.indentSize;
    }

    @Override
    public char indentChar() {
        return this.indentChar;
    }

    @Override
    public String org$apache$daffodil$lib$util$Indentable$$indentString() {
        return this.org$apache$daffodil$lib$util$Indentable$$indentString;
    }

    @Override
    public int org$apache$daffodil$lib$util$Indentable$$indentLength() {
        return this.org$apache$daffodil$lib$util$Indentable$$indentLength;
    }

    @Override
    public void org$apache$daffodil$lib$util$Indentable$$indentString_$eq(String x$1) {
        this.org$apache$daffodil$lib$util$Indentable$$indentString = x$1;
    }

    @Override
    public void org$apache$daffodil$lib$util$Indentable$$indentLength_$eq(int x$1) {
        this.org$apache$daffodil$lib$util$Indentable$$indentLength = x$1;
    }

    @Override
    public void org$apache$daffodil$lib$util$Indentable$_setter_$indentSize_$eq(int x$0) {
        this.indentSize = x$0;
    }

    @Override
    public void org$apache$daffodil$lib$util$Indentable$_setter_$indentChar_$eq(char x$0) {
        this.indentChar = x$0;
    }

    private MStackOf<NamespaceBinding> activePrefixMappingContextStack() {
        Object object = this.activePrefixMappingContextStack$lzy1;
        if (object instanceof MStackOf) {
            return (MStackOf)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (MStackOf)this.activePrefixMappingContextStack$lzyINIT1();
    }

    private Object activePrefixMappingContextStack$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.activePrefixMappingContextStack$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    MStackOf mStackOf = null;
                    try {
                        mStackOf = new MStackOf();
                        object2 = mStackOf == null ? LazyVals.NullValue$.MODULE$ : mStackOf;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.activePrefixMappingContextStack$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return mStackOf;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private boolean outputNewline() {
        return BoxesRunTime.unboxToBoolean(this.outputNewlineStack.top());
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() {
        this.resetIndentation();
        this.activePrefixMapping = null;
        this.currentElementPrefixMapping = null;
        this.activePrefixMappingContextStack().clear();
        this.outputNewlineStack.clear();
        this.outputNewlineStack.push(BoxesRunTime.boxToBoolean((boolean)false));
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    @Override
    public void endDocument() {
        this.writer.write(System.lineSeparator());
        this.writer.flush();
        this.out.flush();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        String string = prefix;
        String string2 = "";
        String _prefix = !(string != null ? !string.equals(string2) : string2 != null) ? null : prefix;
        this.currentElementPrefixMapping = NamespaceBinding$.MODULE$.apply(_prefix, uri, this.currentElementPrefixMapping);
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    public void processAttributePrefixMappings(Attributes atts) {
        for (int i = 0; i < atts.getLength(); ++i) {
            String qName = atts.getQName(i);
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(qName))) continue;
            String string = qName;
            String string2 = "xmlns";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Object pre = null;
                String uri = atts.getValue(i);
                this.currentElementPrefixMapping = NamespaceBinding$.MODULE$.apply(null, uri, this.currentElementPrefixMapping);
                continue;
            }
            if (!qName.startsWith("xmlns:")) continue;
            String pre = qName.substring(6);
            String uri = atts.getValue(i);
            this.currentElementPrefixMapping = NamespaceBinding$.MODULE$.apply(pre, uri, this.currentElementPrefixMapping);
        }
    }

    public void writeNonNamespaceAttributes(OutputStreamWriter writer, Attributes atts) {
        for (int i = 0; i < atts.getLength(); ++i) {
            String qName = atts.getQName(i);
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(qName))) {
                if (qName.startsWith("xmlns:")) continue;
                String string = qName;
                String string2 = "xmlns";
                if (string == null) {
                    if (string2 == null) continue;
                } else if (string.equals(string2)) continue;
                String attrVal = atts.getValue(i);
                String attr = " " + qName + "=\"" + attrVal + "\"";
                writer.write(attr);
                continue;
            }
            String uri = atts.getURI(i);
            String localName = atts.getLocalName(i);
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(uri)) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(localName))) {
                Object maybePrefix = XMLUtils$.MODULE$.maybePrefix(this.activePrefixMapping, uri);
                if (Maybe$.MODULE$.isDefined$extension(maybePrefix)) {
                    String prefix = (String)Maybe$.MODULE$.get$extension(maybePrefix);
                    String attrVal = atts.getValue(i);
                    String attr = " " + prefix + ":" + localName + "=\"" + attrVal + "\"";
                    writer.write(attr);
                    continue;
                }
                throw Assert$.MODULE$.invariantFailed("Cannot have URI with no prefix mapping");
            }
            throw Assert$.MODULE$.invariantFailed("Cannot have an attribute with no qname, uri or localname");
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        this.outputNewlineStack.pop();
        this.outputNewlineStack.push(BoxesRunTime.boxToBoolean((boolean)true));
        if (this.pretty) {
            this.writer.write(System.lineSeparator());
            this.outputIndentation(this.writer);
        }
        this.processAttributePrefixMappings(atts);
        NamespaceBinding previousPrefixMapping = this.activePrefixMapping;
        while (this.currentElementPrefixMapping != null) {
            String prefix = this.currentElementPrefixMapping.prefix();
            String uri2 = this.currentElementPrefixMapping.uri();
            this.activePrefixMapping = NamespaceBinding$.MODULE$.apply(prefix, uri2, this.activePrefixMapping);
            this.currentElementPrefixMapping = this.currentElementPrefixMapping.parent();
        }
        this.activePrefixMappingContextStack().push(this.activePrefixMapping);
        this.writer.write("<");
        this.outputTagName(uri, localName, qName);
        if (this.activePrefixMapping != previousPrefixMapping) {
            String pm = this.activePrefixMapping.buildString(previousPrefixMapping);
            this.writer.write(pm);
        }
        this.writeNonNamespaceAttributes(this.writer, atts);
        this.writer.write(">");
        this.incrementIndentation();
        this.outputNewlineStack.push(BoxesRunTime.boxToBoolean((boolean)false));
    }

    private void outputTagName(String uri, String localName, String qName) {
        Object object;
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(qName))) {
            object = qName;
        } else {
            String sanitizedUri = uri.isEmpty() ? null : uri;
            Object maybePrefix = XMLUtils$.MODULE$.maybePrefix(this.activePrefixMapping, sanitizedUri);
            if (Maybe$.MODULE$.isDefined$extension(maybePrefix)) {
                String pre = (String)Maybe$.MODULE$.get$extension(maybePrefix);
                object = pre + ":" + localName;
            } else {
                object = localName;
            }
        }
        String tagName = object;
        this.writer.write(tagName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.decrementIndentation();
        if (this.outputNewline() && this.pretty) {
            this.writer.write(System.lineSeparator());
            this.outputIndentation(this.writer);
        }
        this.writer.write("</");
        this.outputTagName(uri, localName, qName);
        this.writer.write(">");
        this.outputNewlineStack.pop();
        if (this.activePrefixMappingContextStack().isEmpty()) {
            throw Assert$.MODULE$.abort("Invariant broken: DaffodilParseOutputStreamContentHandler.this.activePrefixMappingContextStack.isEmpty.unary_!");
        }
        this.activePrefixMappingContextStack().pop();
        if (this.activePrefixMappingContextStack().isEmpty()) {
            this.activePrefixMapping = null;
            return;
        }
        this.activePrefixMapping = this.activePrefixMappingContextStack().top();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String str = new String(ch, start, length);
        String escaped = Utility$.MODULE$.escape(str);
        this.writer.write(escaped, 0, escaped.length());
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    @Override
    public void processingInstruction(String target, String data) {
    }

    @Override
    public void skippedEntity(String name) {
    }
}

