/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.inputsource.hdfs;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.List;
import org.apache.druid.data.input.InputSourceFactory;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.data.input.impl.systemfield.SystemFields;
import org.apache.druid.guice.Hdfs;
import org.apache.druid.inputsource.hdfs.HdfsInputSource;
import org.apache.druid.inputsource.hdfs.HdfsInputSourceConfig;
import org.apache.hadoop.conf.Configuration;

public class HdfsInputSourceFactory
implements InputSourceFactory {
    private final Configuration configuration;
    private final HdfsInputSourceConfig inputSourceConfig;

    @JsonCreator
    public HdfsInputSourceFactory(@JacksonInject @Hdfs Configuration configuration, @JacksonInject HdfsInputSourceConfig inputSourceConfig) {
        this.configuration = configuration;
        this.inputSourceConfig = inputSourceConfig;
    }

    public SplittableInputSource create(List<String> inputFilePaths) {
        return new HdfsInputSource(inputFilePaths, SystemFields.none(), this.configuration, this.inputSourceConfig);
    }
}

