/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.google.output;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.HumanReadableBytes;

public class GoogleOutputConfig {
    @JsonProperty
    private final String bucket;
    @JsonProperty
    private final String prefix;
    @Nullable
    @JsonProperty
    private final File tempDir;
    @JsonProperty
    private HumanReadableBytes chunkSize;
    private static final HumanReadableBytes DEFAULT_CHUNK_SIZE = new HumanReadableBytes("4MiB");
    private static final long GOOGLE_MIN_CHUNK_SIZE_BYTES = new HumanReadableBytes("256KiB").getBytes();
    private static final long GOOGLE_MAX_CHUNK_SIZE_BYTES = new HumanReadableBytes("16MiB").getBytes();
    @JsonProperty
    private int maxRetry;

    public GoogleOutputConfig(String bucket, String prefix, @Nullable File tempDir, @Nullable HumanReadableBytes chunkSize, @Nullable Integer maxRetry) {
        this.bucket = bucket;
        this.prefix = prefix;
        this.tempDir = tempDir;
        this.chunkSize = chunkSize != null ? chunkSize : DEFAULT_CHUNK_SIZE;
        this.maxRetry = maxRetry != null ? maxRetry : 10;
        this.validateFields();
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Nullable
    public File getTempDir() {
        return this.tempDir;
    }

    public HumanReadableBytes getChunkSize() {
        return this.chunkSize;
    }

    public Integer getMaxRetry() {
        return this.maxRetry;
    }

    public GoogleOutputConfig withTempDir(File tempDir) {
        return new GoogleOutputConfig(this.bucket, this.prefix, tempDir, this.chunkSize, this.maxRetry);
    }

    private void validateFields() {
        if (this.chunkSize.getBytes() < GOOGLE_MIN_CHUNK_SIZE_BYTES || this.chunkSize.getBytes() > GOOGLE_MAX_CHUNK_SIZE_BYTES) {
            throw InvalidInput.exception((String)"'chunkSize' [%d] bytes to the GoogleConfig should be between [%d] bytes and [%d] bytes", (Object[])new Object[]{this.chunkSize.getBytes(), GOOGLE_MIN_CHUNK_SIZE_BYTES, GOOGLE_MAX_CHUNK_SIZE_BYTES});
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoogleOutputConfig that = (GoogleOutputConfig)o;
        return Objects.equals(this.bucket, that.bucket) && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.tempDir, that.tempDir) && Objects.equals(this.chunkSize, that.chunkSize) && Objects.equals(this.maxRetry, that.maxRetry);
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.prefix, this.tempDir, this.chunkSize, this.maxRetry);
    }

    public String toString() {
        return "GoogleOutputConfig{container='" + this.bucket + "', prefix='" + this.prefix + "', tempDir=" + this.tempDir + ", chunkSize=" + this.chunkSize + ", maxRetry=" + this.maxRetry + "}";
    }
}

