/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.ClientResponse;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.security.basic.BasicAuthDBConfig;
import org.apache.druid.server.DruidNode;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.joda.time.Duration;

public class CommonCacheNotifier {
    private static final EmittingLogger LOG = new EmittingLogger(CommonCacheNotifier.class);
    private static final List<NodeRole> NODE_TYPES = Arrays.asList(NodeRole.BROKER, NodeRole.OVERLORD, NodeRole.HISTORICAL, NodeRole.PEON, NodeRole.ROUTER, NodeRole.MIDDLE_MANAGER, NodeRole.INDEXER);
    private final DruidNodeDiscoveryProvider discoveryProvider;
    private final HttpClient httpClient;
    private final BlockingQueue<Pair<String, byte[]>> updateQueue;
    private final Map<String, BasicAuthDBConfig> itemConfigMap;
    private final String baseUrl;
    private final String callerName;
    private final ExecutorService exec;

    public CommonCacheNotifier(Map<String, BasicAuthDBConfig> itemConfigMap, DruidNodeDiscoveryProvider discoveryProvider, HttpClient httpClient, String baseUrl, String callerName) {
        this.exec = Execs.singleThreaded((String)(StringUtils.format((String)"%s-notifierThread-", (Object[])new Object[]{StringUtils.encodeForFormat((String)callerName)}) + "%d"));
        this.callerName = callerName;
        this.updateQueue = new LinkedBlockingQueue<Pair<String, byte[]>>();
        this.itemConfigMap = itemConfigMap;
        this.discoveryProvider = discoveryProvider;
        this.httpClient = httpClient;
        this.baseUrl = baseUrl;
    }

    public void start() {
        this.exec.submit(() -> {
            while (!Thread.interrupted()) {
                try {
                    LOG.debug(this.callerName + ":Waiting for cache update notification", new Object[0]);
                    Pair<String, byte[]> update = this.updateQueue.take();
                    String authorizer = (String)update.lhs;
                    byte[] serializedMap = (byte[])update.rhs;
                    BasicAuthDBConfig authorizerConfig = this.itemConfigMap.get(update.lhs);
                    if (!authorizerConfig.isEnableCacheNotifications()) continue;
                    LOG.debug(this.callerName + ":Sending cache update notifications", new Object[0]);
                    List<ListenableFuture<StatusResponseHolder>> futures = this.sendUpdate(authorizer, serializedMap);
                    try {
                        List responses = (List)Futures.allAsList(futures).get(authorizerConfig.getCacheNotificationTimeout(), TimeUnit.MILLISECONDS);
                        for (StatusResponseHolder response : responses) {
                            LOG.debug(this.callerName + ":Got status: " + response.getStatus(), new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        LOG.makeAlert((Throwable)e, this.callerName + ":Failed to get response for cache notification.", new Object[0]).emit();
                    }
                    LOG.debug(this.callerName + ":Received responses for cache update notifications.", new Object[0]);
                }
                catch (InterruptedException e) {
                    LOG.noStackTrace().info((Throwable)e, "%s: Interrupted while handling updates for cachedUserMaps.", new Object[]{this.callerName});
                }
                catch (Throwable t) {
                    LOG.makeAlert(t, this.callerName + ":Error occurred while handling updates for cachedUserMaps.", new Object[0]).emit();
                }
            }
        });
    }

    public void stop() {
        this.exec.shutdownNow();
    }

    public void addUpdate(String updatedItemName, byte[] updatedItemData) {
        this.updateQueue.add((Pair<String, byte[]>)new Pair((Object)updatedItemName, (Object)updatedItemData));
    }

    private List<ListenableFuture<StatusResponseHolder>> sendUpdate(String updatedAuthenticatorPrefix, byte[] serializedEntity) {
        ArrayList<ListenableFuture<StatusResponseHolder>> futures = new ArrayList<ListenableFuture<StatusResponseHolder>>();
        for (NodeRole nodeRole : NODE_TYPES) {
            DruidNodeDiscovery nodeDiscovery = this.discoveryProvider.getForNodeRole(nodeRole);
            Collection nodes = nodeDiscovery.getAllNodes();
            for (DiscoveryDruidNode node : nodes) {
                URL listenerURL = this.getListenerURL(node.getDruidNode(), StringUtils.format((String)this.baseUrl, (Object[])new Object[]{StringUtils.urlEncode((String)updatedAuthenticatorPrefix)}));
                Request req = new Request(HttpMethod.POST, listenerURL);
                req.setContent("application/json", serializedEntity);
                BasicAuthDBConfig itemConfig = this.itemConfigMap.get(updatedAuthenticatorPrefix);
                ListenableFuture future = this.httpClient.go(req, (HttpResponseHandler)new ResponseHandler(), Duration.millis((long)itemConfig.getCacheNotificationTimeout()));
                futures.add((ListenableFuture<StatusResponseHolder>)future);
            }
        }
        return futures;
    }

    private URL getListenerURL(DruidNode druidNode, String baseUrl) {
        try {
            return new URL(druidNode.getServiceScheme(), druidNode.getHost(), druidNode.getPortToUse(), baseUrl);
        }
        catch (MalformedURLException mue) {
            LOG.error(this.callerName + ": Malformed url for DruidNode[%s] and baseUrl[%s]", new Object[]{druidNode, baseUrl});
            throw new RuntimeException(mue);
        }
    }

    private static class ResponseHandler
    implements HttpResponseHandler<StatusResponseHolder, StatusResponseHolder> {
        protected static final Logger log = new Logger(ResponseHandler.class);

        private ResponseHandler() {
        }

        public ClientResponse<StatusResponseHolder> handleResponse(HttpResponse response, HttpResponseHandler.TrafficCop trafficCop) {
            return ClientResponse.unfinished((Object)new StatusResponseHolder(response.getStatus(), null));
        }

        public ClientResponse<StatusResponseHolder> handleChunk(ClientResponse<StatusResponseHolder> response, HttpChunk chunk, long chunkNum) {
            return response;
        }

        public ClientResponse<StatusResponseHolder> done(ClientResponse<StatusResponseHolder> response) {
            return ClientResponse.finished((Object)((StatusResponseHolder)response.getObj()));
        }

        public void exceptionCaught(ClientResponse<StatusResponseHolder> clientResponse, Throwable e) {
            log.error(e, "exceptionCaught in CommonCacheNotifier ResponseHandler.", new Object[0]);
        }
    }
}

