/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.utils.CollectionUtils;

public class Selector {
    private final String selectionKey;
    private final Map<String, Set<String>> cxtTagsConditions;
    private final Set<String> taskTypeCondition;
    private final Set<String> dataSourceCondition;

    @JsonCreator
    public Selector(@JsonProperty(value="selectionKey") String selectionKey, @JsonProperty(value="context.tags") Map<String, Set<String>> cxtTagsConditions, @JsonProperty(value="type") Set<String> taskTypeCondition, @JsonProperty(value="dataSource") Set<String> dataSourceCondition) {
        this.selectionKey = selectionKey;
        this.cxtTagsConditions = cxtTagsConditions;
        this.taskTypeCondition = taskTypeCondition;
        this.dataSourceCondition = dataSourceCondition;
    }

    public boolean evaluate(Task task) {
        boolean isMatch = true;
        if (this.cxtTagsConditions != null) {
            isMatch = this.cxtTagsConditions.entrySet().stream().allMatch(entry -> {
                String tagKey = (String)entry.getKey();
                Set tagValues = (Set)entry.getValue();
                Map tags = (Map)task.getContextValue("tags");
                if (tags == null || tags.isEmpty()) {
                    return false;
                }
                Object tagValue = tags.get(tagKey);
                return tagValue != null && tagValues.contains((String)tagValue);
            });
        }
        if (isMatch && !CollectionUtils.isNullOrEmpty(this.taskTypeCondition)) {
            isMatch = this.taskTypeCondition.contains(task.getType());
        }
        if (isMatch && !CollectionUtils.isNullOrEmpty(this.dataSourceCondition)) {
            isMatch = this.dataSourceCondition.contains(task.getDataSource());
        }
        return isMatch;
    }

    @JsonProperty
    public String getSelectionKey() {
        return this.selectionKey;
    }

    @JsonProperty(value="context.tags")
    public Map<String, Set<String>> getCxtTagsConditions() {
        return this.cxtTagsConditions;
    }

    @JsonProperty(value="type")
    public Set<String> getTaskTypeCondition() {
        return this.taskTypeCondition;
    }

    @JsonProperty(value="dataSource")
    public Set<String> getDataSourceCondition() {
        return this.dataSourceCondition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Selector selector = (Selector)o;
        return Objects.equals(this.selectionKey, selector.selectionKey) && Objects.equals(this.cxtTagsConditions, selector.cxtTagsConditions) && Objects.equals(this.taskTypeCondition, selector.taskTypeCondition) && Objects.equals(this.dataSourceCondition, selector.dataSourceCondition);
    }

    public int hashCode() {
        return Objects.hash(this.selectionKey, this.cxtTagsConditions, this.taskTypeCondition, this.dataSourceCondition);
    }

    public String toString() {
        return "Selector{selectionKey=" + this.selectionKey + ", context.tags=" + this.cxtTagsConditions + ", type=" + this.taskTypeCondition + ", dataSource=" + this.dataSourceCondition + "}";
    }
}

