/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainer;

public class LookupUtils {
    private static final EmittingLogger LOG = new EmittingLogger(LookupUtils.class);

    private LookupUtils() {
    }

    public static Map<String, LookupExtractorFactoryContainer> tryConvertObjectMapToLookupConfigMap(Map<String, Object> lookupNameToGenericConfig, ObjectMapper objectMapper) {
        HashMap lookupNameToConfig = Maps.newHashMapWithExpectedSize((int)lookupNameToGenericConfig.size());
        for (Map.Entry<String, Object> lookupNameAndConfig : lookupNameToGenericConfig.entrySet()) {
            String lookupName = lookupNameAndConfig.getKey();
            LookupExtractorFactoryContainer lookupConfig = LookupUtils.tryConvertObjectToLookupConfig(lookupName, lookupNameAndConfig.getValue(), objectMapper);
            if (lookupConfig == null) continue;
            lookupNameToConfig.put(lookupName, lookupConfig);
        }
        return lookupNameToConfig;
    }

    @Nullable
    private static LookupExtractorFactoryContainer tryConvertObjectToLookupConfig(String lookupName, Object o, ObjectMapper objectMapper) {
        try {
            byte[] lookupConfigBytes = objectMapper.writeValueAsBytes(o);
            return (LookupExtractorFactoryContainer)objectMapper.readValue(lookupConfigBytes, LookupExtractorFactoryContainer.class);
        }
        catch (IOException e) {
            LOG.warn("Lookup [%s] could not be serialized properly. Please check its configuration. Error: %s", new Object[]{lookupName, e.getMessage()});
            return null;
        }
    }
}

