/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.SingleValueAggregator;
import org.apache.druid.query.aggregation.SingleValueBufferAggregator;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;

@JsonTypeName(value="singleValue")
public class SingleValueAggregatorFactory
extends AggregatorFactory {
    @JsonProperty
    private final String name;
    @JsonProperty
    private final String fieldName;
    @JsonProperty
    private final ColumnType columnType;
    public static final int DEFAULT_MAX_VALUE_SIZE = 1024;

    @JsonCreator
    public SingleValueAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="columnType") ColumnType columnType) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.fieldName = (String)Preconditions.checkNotNull((Object)fieldName, (Object)"fieldName");
        this.columnType = (ColumnType)Preconditions.checkNotNull((Object)columnType, (Object)"columnType");
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        return new SingleValueAggregator(selector);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        ColumnCapabilities columnCapabilities = metricFactory.getColumnCapabilities(this.fieldName);
        if (columnCapabilities == null) {
            throw DruidException.forPersona(DruidException.Persona.DEVELOPER).ofCategory(DruidException.Category.DEFENSIVE).build("Unable to get the capabilities of field [%s]", this.fieldName);
        }
        ColumnType columnType = new ColumnType((ValueType)columnCapabilities.getType(), null, null);
        return new SingleValueBufferAggregator(selector, columnType);
    }

    @Override
    public Comparator getComparator() {
        throw DruidException.defensive("Single Value Aggregator would not have more than one row to compare", new Object[0]);
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        throw DruidException.defensive("Single Value Aggregator would not have more than one row to combine", new Object[0]);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new SingleValueAggregatorFactory(this.name, this.name, this.columnType);
    }

    @Override
    public Object deserialize(Object object) {
        return object;
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object;
    }

    @Override
    public ColumnType getIntermediateType() {
        return this.columnType;
    }

    @Override
    public ColumnType getResultType() {
        return this.columnType;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    @Override
    public int getMaxIntermediateSize() {
        return 1 + (this.columnType.isNumeric() ? 8 : 1024);
    }

    @Override
    public byte[] getCacheKey() {
        return new byte[]{79};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleValueAggregatorFactory that = (SingleValueAggregatorFactory)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.columnType, that.columnType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldName, this.columnType);
    }

    public String toString() {
        return "SingleValueAggregatorFactory{name='" + this.name + "', fieldName='" + this.fieldName + "', columnType=" + String.valueOf(this.columnType) + "}";
    }
}

