/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.planning;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.planning.ExecutionVertexShuttle;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.SegmentMapFunction;
import org.apache.druid.segment.join.JoinPrefixUtils;
import org.joda.time.Interval;

public class ExecutionVertex {
    protected final Query<?> topQuery;
    protected final DataSource baseDataSource;
    protected final QuerySegmentSpec querySegmentSpec;
    protected final List<String> joinPrefixes;
    protected boolean allRightsAreGlobal;

    private ExecutionVertex(ExecutionVertexExplorer explorer) {
        this.topQuery = explorer.topQuery;
        this.baseDataSource = explorer.baseDataSource;
        this.querySegmentSpec = explorer.querySegmentSpec;
        this.joinPrefixes = explorer.joinPrefixes;
        this.allRightsAreGlobal = explorer.allRightsAreGlobal;
    }

    public static ExecutionVertex of(Query<?> query) {
        ExecutionVertexExplorer explorer = new ExecutionVertexExplorer(query);
        return new ExecutionVertex(explorer);
    }

    public DataSource getBaseDataSource() {
        return this.baseDataSource;
    }

    public boolean isProcessable() {
        return this.getBaseDataSource().isProcessable() && this.allRightsAreGlobal;
    }

    public boolean isTableBased() {
        return this.baseDataSource instanceof TableDataSource || this.baseDataSource instanceof UnionDataSource && ((UnionDataSource)this.baseDataSource).isTableBased();
    }

    public static ExecutionVertex ofDataSource(DataSource dataSource) {
        ScanQuery query = Druids.newScanQueryBuilder().intervals(new MultipleIntervalSegmentSpec((List<Interval>)Intervals.ONLY_ETERNITY)).dataSource(dataSource).build();
        return ExecutionVertex.of(query);
    }

    public final TableDataSource getBaseTableDataSource() {
        if (this.baseDataSource instanceof TableDataSource) {
            return (TableDataSource)this.baseDataSource;
        }
        throw DruidException.defensive("Base dataSource[%s] is not a table!", this.baseDataSource);
    }

    public QuerySegmentSpec getEffectiveQuerySegmentSpec() {
        Preconditions.checkNotNull((Object)this.querySegmentSpec, (Object)"querySegmentSpec is null!");
        return this.querySegmentSpec;
    }

    public boolean canRunQueryUsingClusterWalker() {
        return this.isProcessable() && this.isTableBased();
    }

    public boolean canRunQueryUsingLocalWalker() {
        return this.isProcessable() && !this.isTableBased();
    }

    public boolean isSegmentMapFunctionExpensive() {
        boolean hasJoin = !this.joinPrefixes.isEmpty();
        return hasJoin;
    }

    public boolean isBaseColumn(String columnName) {
        for (String prefix : this.joinPrefixes) {
            if (!JoinPrefixUtils.isPrefixedBy(columnName, prefix)) continue;
            return false;
        }
        return true;
    }

    public Query buildQueryWithBaseDataSource(DataSource newBaseDataSource) {
        return new ReplaceBaseDataSource(this.baseDataSource, newBaseDataSource).traverse(this.topQuery);
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public SegmentMapFunction createSegmentMapFunction(PolicyEnforcer policyEnforcer) {
        return this.getTopDataSource().createSegmentMapFunction(this.topQuery).thenMap(segment -> {
            segment.validateOrElseThrow(policyEnforcer);
            return segment;
        });
    }

    private DataSource getTopDataSource() {
        Query q = this.topQuery;
        while (q.mayCollapseQueryDataSource()) {
            q = ((QueryDataSource)q.getDataSource()).getQuery();
        }
        return q.getDataSource();
    }

    static class ExecutionVertexExplorer
    extends ExecutionVertexShuttle {
        boolean discoveringBase = true;
        DataSource baseDataSource;
        QuerySegmentSpec querySegmentSpec;
        Query<?> topQuery;
        List<String> joinPrefixes = new ArrayList<String>();
        boolean allRightsAreGlobal = true;

        public ExecutionVertexExplorer(Query<?> query) {
            this.topQuery = query;
            this.traverse(query);
        }

        @Override
        protected boolean mayTraverseQuery(Query<?> query) {
            return true;
        }

        @Override
        protected boolean mayTraverseDataSource(ExecutionVertexShuttle.EVNode node) {
            ExecutionVertexShuttle.EVNode parentNode;
            if (this.parents.size() < 2) {
                return true;
            }
            if (node.index != null && node.index > 0) {
                return false;
            }
            if (node.dataSource instanceof QueryDataSource && (parentNode = (ExecutionVertexShuttle.EVNode)this.parents.get(this.parents.size() - 2)).isQuery()) {
                return parentNode.getQuery().mayCollapseQueryDataSource();
            }
            return !(node.dataSource instanceof UnionDataSource);
        }

        @Override
        protected DataSource visit(DataSource dataSource, boolean leaf) {
            if (this.discoveringBase) {
                this.baseDataSource = dataSource;
                this.discoveringBase = false;
            }
            if (!leaf && dataSource instanceof JoinDataSource) {
                JoinDataSource joinDataSource = (JoinDataSource)dataSource;
                this.joinPrefixes.add(joinDataSource.getRightPrefix());
            }
            if (leaf && !this.isLeftLeaning()) {
                this.allRightsAreGlobal = this.allRightsAreGlobal && dataSource.isGlobal();
            }
            return dataSource;
        }

        private boolean isLeftLeaning() {
            for (ExecutionVertexShuttle.EVNode evNode : this.parents) {
                if (evNode.index == null || evNode.index == 0) continue;
                return false;
            }
            return true;
        }

        @Override
        protected Query<?> visitQuery(Query<?> query) {
            if (this.querySegmentSpec == null && this.isLeftLeaning()) {
                this.querySegmentSpec = this.getQuerySegmentSpec(query);
            }
            return query;
        }

        private QuerySegmentSpec getQuerySegmentSpec(Query<?> query) {
            BaseQuery baseQuery;
            if (query instanceof BaseQuery && (baseQuery = (BaseQuery)query).getQuerySegmentSpec() != null) {
                return baseQuery.getQuerySegmentSpec();
            }
            return new MultipleIntervalSegmentSpec((List<Interval>)Intervals.ONLY_ETERNITY);
        }
    }

    static class ReplaceBaseDataSource
    extends ExecutionVertexShuttle {
        private DataSource newBaseDataSource;
        private DataSource oldBaseDataSource;

        public ReplaceBaseDataSource(DataSource oldBaseDataSource, DataSource newBaseDataSource) {
            this.oldBaseDataSource = oldBaseDataSource;
            this.newBaseDataSource = newBaseDataSource;
        }

        @Override
        protected boolean mayTraverseQuery(Query<?> query) {
            return true;
        }

        @Override
        protected boolean mayTraverseDataSource(ExecutionVertexShuttle.EVNode evNode) {
            return true;
        }

        @Override
        protected DataSource visit(DataSource dataSource, boolean leaf) {
            if (dataSource == this.oldBaseDataSource) {
                return this.newBaseDataSource;
            }
            return dataSource;
        }

        @Override
        protected Query<?> visitQuery(Query<?> query) {
            return query;
        }
    }
}

