/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ZeroIndexedInts;

public abstract class BaseSingleValueDimensionSelector
implements DimensionSelector {
    @Nullable
    protected abstract String getValue();

    @Override
    public IndexedInts getRow() {
        return ZeroIndexedInts.instance();
    }

    @Override
    public int getValueCardinality() {
        return -1;
    }

    @Override
    public String lookupName(int id) {
        return this.getValue();
    }

    @Override
    public ValueMatcher makeValueMatcher(final @Nullable String value) {
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                String rowValue = BaseSingleValueDimensionSelector.this.getValue();
                return includeUnknown && rowValue == null || Objects.equals(rowValue, value);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", BaseSingleValueDimensionSelector.this);
            }
        };
    }

    @Override
    public ValueMatcher makeValueMatcher(final DruidPredicateFactory predicateFactory) {
        final DruidObjectPredicate<String> predicate = predicateFactory.makeStringPredicate();
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                String rowValue = BaseSingleValueDimensionSelector.this.getValue();
                return predicate.apply(rowValue).matches(includeUnknown);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", BaseSingleValueDimensionSelector.this);
                inspector.visit("predicate", predicateFactory);
            }
        };
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return false;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return null;
    }

    @Override
    @Nullable
    public String getObject() {
        return this.getValue();
    }

    @Override
    public Class<String> classOfObject() {
        return String.class;
    }
}

