/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentLazyLoadFailCallback;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.loading.SegmentizerFactory;
import org.apache.druid.timeline.DataSegment;

public class MMappedQueryableSegmentizerFactory
implements SegmentizerFactory {
    private final IndexIO indexIO;

    public MMappedQueryableSegmentizerFactory(@JacksonInject IndexIO indexIO) {
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"Null IndexIO");
    }

    @Override
    public Segment factorize(DataSegment dataSegment, File parentDir, boolean lazy, SegmentLazyLoadFailCallback loadFailed) throws SegmentLoadingException {
        try {
            return new QueryableIndexSegment(this.indexIO.loadIndex(parentDir, lazy, loadFailed), dataSegment.getId());
        }
        catch (IOException e) {
            throw new SegmentLoadingException(e, "%s", e.getMessage());
        }
    }
}

