/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.resources;

import com.github.rvesse.airline.parser.resources.ResourceLocator;
import java.io.IOException;
import java.io.InputStream;

public class ClasspathLocator
implements ResourceLocator {
    public static final String CLASSPATH_URI_PREFIX = "classpath:";

    @Override
    public InputStream open(String searchLocation, String filename) throws IOException {
        InputStream locStream;
        if (searchLocation == null) {
            return null;
        }
        if (searchLocation.startsWith(CLASSPATH_URI_PREFIX)) {
            searchLocation = searchLocation.substring(CLASSPATH_URI_PREFIX.length());
        }
        StringBuilder resourceName = new StringBuilder();
        resourceName.append(searchLocation);
        if (!searchLocation.endsWith("/")) {
            resourceName.append("/");
        }
        resourceName.append(filename);
        InputStream resourceStream = ClasspathLocator.class.getResourceAsStream(resourceName.toString());
        if (resourceStream != null) {
            return resourceStream;
        }
        if (!searchLocation.endsWith("/") && (locStream = ClasspathLocator.class.getResourceAsStream(searchLocation)) != null) {
            return locStream;
        }
        return null;
    }
}

