/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure.output;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.HumanReadableBytes;

public class AzureOutputConfig {
    @JsonProperty
    private final String container;
    @JsonProperty
    private final String prefix;
    @Nullable
    @JsonProperty
    private final File tempDir;
    @JsonProperty
    private final HumanReadableBytes chunkSize;
    private static final HumanReadableBytes DEFAULT_CHUNK_SIZE = new HumanReadableBytes("4MiB");
    private static final long AZURE_MIN_CHUNK_SIZE_BYTES = new HumanReadableBytes("256KiB").getBytes();
    private static final long AZURE_MAX_CHUNK_SIZE_BYTES = new HumanReadableBytes("4000MiB").getBytes();
    @JsonProperty
    private final int maxRetry;

    public AzureOutputConfig(@JsonProperty(value="container", required=true) String container, @JsonProperty(value="prefix", required=true) String prefix, @JsonProperty(value="tempDir") @Nullable File tempDir, @JsonProperty(value="chunkSize") @Nullable HumanReadableBytes chunkSize, @JsonProperty(value="maxRetry") @Nullable Integer maxRetry) {
        this.container = container;
        this.prefix = prefix;
        this.tempDir = tempDir;
        this.chunkSize = chunkSize != null ? chunkSize : DEFAULT_CHUNK_SIZE;
        this.maxRetry = maxRetry != null ? maxRetry : 10;
        this.validateFields();
    }

    public String getContainer() {
        return this.container;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Nullable
    public File getTempDir() {
        return this.tempDir;
    }

    public HumanReadableBytes getChunkSize() {
        return this.chunkSize;
    }

    public int getMaxRetry() {
        return this.maxRetry;
    }

    public AzureOutputConfig withTempDir(File tempDir) {
        return new AzureOutputConfig(this.container, this.prefix, tempDir, this.chunkSize, this.maxRetry);
    }

    private void validateFields() {
        if (this.chunkSize.getBytes() < AZURE_MIN_CHUNK_SIZE_BYTES || this.chunkSize.getBytes() > AZURE_MAX_CHUNK_SIZE_BYTES) {
            throw InvalidInput.exception((String)"'chunkSize' [%d] bytes to the AzureConfig should be between [%d] bytes and [%d] bytes", (Object[])new Object[]{this.chunkSize.getBytes(), AZURE_MIN_CHUNK_SIZE_BYTES, AZURE_MAX_CHUNK_SIZE_BYTES});
        }
    }

    public void validateTempDirectory() {
        if (this.tempDir == null) {
            throw DruidException.defensive((String)"The runtime property `druid.msq.intermediate.storage.tempDir` must be configured.", (Object[])new Object[0]);
        }
        try {
            FileUtils.mkdirp((File)this.tempDir);
        }
        catch (IOException e) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.ADMIN).ofCategory(DruidException.Category.RUNTIME_FAILURE).build((Throwable)e, "Unable to create temporary directory [%s]", new Object[]{this.tempDir.getAbsolutePath()});
        }
        if (!this.tempDir.canRead() || !this.tempDir.canWrite()) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.ADMIN).ofCategory(DruidException.Category.RUNTIME_FAILURE).build("Cannot read or write on the 'tempDir' [%s]. Please provide a different path to store the intermediate contents of AzureStorageConnector", new Object[]{this.tempDir.getAbsolutePath()});
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureOutputConfig that = (AzureOutputConfig)o;
        return this.maxRetry == that.maxRetry && Objects.equals(this.container, that.container) && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.tempDir, that.tempDir) && Objects.equals(this.chunkSize, that.chunkSize);
    }

    public int hashCode() {
        return Objects.hash(this.container, this.prefix, this.tempDir, this.chunkSize, this.maxRetry);
    }

    public String toString() {
        return "AzureOutputConfig{container='" + this.container + "', prefix='" + this.prefix + "', tempDir=" + String.valueOf(this.tempDir) + ", chunkSize=" + String.valueOf(this.chunkSize) + ", maxRetry=" + this.maxRetry + "}";
    }
}

