/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.MediaDeviceInfo;
import com.amazonaws.services.ec2.model.transform.MediaDeviceMemoryInfoStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class MediaDeviceInfoStaxUnmarshaller
implements Unmarshaller<MediaDeviceInfo, StaxUnmarshallerContext> {
    private static MediaDeviceInfoStaxUnmarshaller instance;

    public MediaDeviceInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        MediaDeviceInfo mediaDeviceInfo = new MediaDeviceInfo();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return mediaDeviceInfo;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("count", targetDepth)) {
                    mediaDeviceInfo.setCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("name", targetDepth)) {
                    mediaDeviceInfo.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("manufacturer", targetDepth)) {
                    mediaDeviceInfo.setManufacturer(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("memoryInfo", targetDepth)) continue;
                mediaDeviceInfo.setMemoryInfo(MediaDeviceMemoryInfoStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return mediaDeviceInfo;
    }

    public static MediaDeviceInfoStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MediaDeviceInfoStaxUnmarshaller();
        }
        return instance;
    }
}

