/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ModifySecurityGroupRulesRequest;
import com.amazonaws.services.ec2.model.SecurityGroupRuleRequest;
import com.amazonaws.services.ec2.model.SecurityGroupRuleUpdate;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifySecurityGroupRulesRequestMarshaller
implements Marshaller<Request<ModifySecurityGroupRulesRequest>, ModifySecurityGroupRulesRequest> {
    public Request<ModifySecurityGroupRulesRequest> marshall(ModifySecurityGroupRulesRequest modifySecurityGroupRulesRequest) {
        SdkInternalList modifySecurityGroupRulesRequestSecurityGroupRulesList;
        if (modifySecurityGroupRulesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifySecurityGroupRulesRequest, "AmazonEC2");
        request.addParameter("Action", "ModifySecurityGroupRules");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifySecurityGroupRulesRequest.getGroupId() != null) {
            request.addParameter("GroupId", StringUtils.fromString((String)modifySecurityGroupRulesRequest.getGroupId()));
        }
        if (!(modifySecurityGroupRulesRequestSecurityGroupRulesList = (SdkInternalList)modifySecurityGroupRulesRequest.getSecurityGroupRules()).isEmpty() || !modifySecurityGroupRulesRequestSecurityGroupRulesList.isAutoConstruct()) {
            int securityGroupRulesListIndex = 1;
            for (SecurityGroupRuleUpdate modifySecurityGroupRulesRequestSecurityGroupRulesListValue : modifySecurityGroupRulesRequestSecurityGroupRulesList) {
                SecurityGroupRuleRequest securityGroupRule;
                if (modifySecurityGroupRulesRequestSecurityGroupRulesListValue.getSecurityGroupRuleId() != null) {
                    request.addParameter("SecurityGroupRule." + securityGroupRulesListIndex + ".SecurityGroupRuleId", StringUtils.fromString((String)modifySecurityGroupRulesRequestSecurityGroupRulesListValue.getSecurityGroupRuleId()));
                }
                if ((securityGroupRule = modifySecurityGroupRulesRequestSecurityGroupRulesListValue.getSecurityGroupRule()) != null) {
                    if (securityGroupRule.getIpProtocol() != null) {
                        request.addParameter("SecurityGroupRule." + securityGroupRulesListIndex + ".SecurityGroupRule.IpProtocol", StringUtils.fromString((String)securityGroupRule.getIpProtocol()));
                    }
                    if (securityGroupRule.getFromPort() != null) {
                        request.addParameter("SecurityGroupRule." + securityGroupRulesListIndex + ".SecurityGroupRule.FromPort", StringUtils.fromInteger((Integer)securityGroupRule.getFromPort()));
                    }
                    if (securityGroupRule.getToPort() != null) {
                        request.addParameter("SecurityGroupRule." + securityGroupRulesListIndex + ".SecurityGroupRule.ToPort", StringUtils.fromInteger((Integer)securityGroupRule.getToPort()));
                    }
                    if (securityGroupRule.getCidrIpv4() != null) {
                        request.addParameter("SecurityGroupRule." + securityGroupRulesListIndex + ".SecurityGroupRule.CidrIpv4", StringUtils.fromString((String)securityGroupRule.getCidrIpv4()));
                    }
                    if (securityGroupRule.getCidrIpv6() != null) {
                        request.addParameter("SecurityGroupRule." + securityGroupRulesListIndex + ".SecurityGroupRule.CidrIpv6", StringUtils.fromString((String)securityGroupRule.getCidrIpv6()));
                    }
                    if (securityGroupRule.getPrefixListId() != null) {
                        request.addParameter("SecurityGroupRule." + securityGroupRulesListIndex + ".SecurityGroupRule.PrefixListId", StringUtils.fromString((String)securityGroupRule.getPrefixListId()));
                    }
                    if (securityGroupRule.getReferencedGroupId() != null) {
                        request.addParameter("SecurityGroupRule." + securityGroupRulesListIndex + ".SecurityGroupRule.ReferencedGroupId", StringUtils.fromString((String)securityGroupRule.getReferencedGroupId()));
                    }
                    if (securityGroupRule.getDescription() != null) {
                        request.addParameter("SecurityGroupRule." + securityGroupRulesListIndex + ".SecurityGroupRule.Description", StringUtils.fromString((String)securityGroupRule.getDescription()));
                    }
                }
                ++securityGroupRulesListIndex;
            }
        }
        return request;
    }
}

