/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.external;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.druid.catalog.model.table.ExternalTableSpec;
import org.apache.druid.catalog.model.table.TableFunction;
import org.apache.druid.sql.calcite.external.Externals;
import org.apache.druid.sql.calcite.external.SchemaAwareUserDefinedTableMacro;

public class DruidTableMacro
implements SchemaAwareUserDefinedTableMacro.ExtendedTableMacro {
    protected final String name;
    final List<FunctionParameter> parameters;
    private final TableFunction fn;
    private final ObjectMapper jsonMapper;

    public DruidTableMacro(String name, TableFunction fn, ObjectMapper jsonMapper) {
        this.name = name;
        this.jsonMapper = jsonMapper;
        this.fn = fn;
        this.parameters = Externals.convertParameters(fn);
    }

    public TranslatableTable apply(List<?> arguments) {
        return this.apply(arguments, null);
    }

    @Override
    public TranslatableTable apply(List<?> arguments, SqlNodeList schema) {
        ExternalTableSpec externSpec = this.fn.apply(this.name, Externals.convertArguments(this.fn, arguments), schema == null ? null : Externals.convertColumns(schema), this.jsonMapper);
        return Externals.buildExternalTable(externSpec, this.jsonMapper);
    }

    public List<FunctionParameter> getParameters() {
        return this.parameters;
    }

    public ObjectMapper getJsonMapper() {
        return this.jsonMapper;
    }
}

