/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.statemachine.event;

import org.apache.flink.streaming.examples.statemachine.dfa.State;
import org.apache.flink.streaming.examples.statemachine.event.Event;
import org.apache.flink.streaming.examples.statemachine.event.EventType;
import org.apache.flink.util.Preconditions;

public class Alert {
    private final int address;
    private final State state;
    private final EventType transition;

    public Alert(int address, State state, EventType transition) {
        this.address = address;
        this.state = (State)((Object)Preconditions.checkNotNull((Object)((Object)state)));
        this.transition = (EventType)((Object)Preconditions.checkNotNull((Object)((Object)transition)));
    }

    public int address() {
        return this.address;
    }

    public State state() {
        return this.state;
    }

    public EventType transition() {
        return this.transition;
    }

    public int hashCode() {
        int code = 31 * this.address + this.state.hashCode();
        return 31 * code + this.transition.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Alert that = (Alert)obj;
        return this.address == that.address && this.transition == that.transition && this.state == that.state;
    }

    public String toString() {
        return "ALERT " + Event.formatAddress(this.address) + " : " + this.state.name() + " -> " + this.transition.name();
    }
}

