/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.LinkedHashMap;
import org.apache.flink.sql.parser.SqlPartitionUtils;
import org.apache.flink.sql.parser.ddl.SqlAlterMaterializedTableRefresh;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.materializedtable.AlterMaterializedTableRefreshOperation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;

public class SqlAlterMaterializedTableRefreshConverter
implements SqlNodeConverter<SqlAlterMaterializedTableRefresh> {
    @Override
    public Operation convertSqlNode(SqlAlterMaterializedTableRefresh node, SqlNodeConverter.ConvertContext context) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])node.fullTableName());
        ObjectIdentifier identifier = context.getCatalogManager().qualifyIdentifier(unresolvedIdentifier);
        LinkedHashMap<String, String> partitionSpec = SqlPartitionUtils.getPartitionKVs(node.getPartitionSpec());
        return new AlterMaterializedTableRefreshOperation(identifier, partitionSpec);
    }
}

