/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.inference.strategies.StrategyUtils;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
class DecimalTimesTypeStrategy
implements TypeStrategy {
    DecimalTimesTypeStrategy() {
    }

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        LogicalType factor1 = argumentDataTypes.get(0).getLogicalType();
        LogicalType factor2 = argumentDataTypes.get(1).getLogicalType();
        if (factor1 instanceof LegacyTypeInformationType) {
            return Optional.of(argumentDataTypes.get(0));
        }
        if (factor2 instanceof LegacyTypeInformationType) {
            return Optional.of(argumentDataTypes.get(1));
        }
        if (!StrategyUtils.isDecimalComputation(factor1, factor2)) {
            return Optional.empty();
        }
        DecimalType decimalType = LogicalTypeMerging.findMultiplicationDecimalType(LogicalTypeChecks.getPrecision(factor1), LogicalTypeChecks.getScale(factor1), LogicalTypeChecks.getPrecision(factor2), LogicalTypeChecks.getScale(factor2));
        return Optional.of(TypeConversions.fromLogicalToDataType(decimalType));
    }
}

