/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.operations.converters.SqlAlterCatalogCommentConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterCatalogOptionsConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterCatalogResetConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterMaterializedTableAsQueryConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterMaterializedTableRefreshConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterMaterializedTableResumeConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterMaterializedTableSuspendConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterTableAddPartitionConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterTableDropPartitionConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterViewAsConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterViewPropertiesConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterViewRenameConverter;
import org.apache.flink.table.planner.operations.converters.SqlCreateCatalogConverter;
import org.apache.flink.table.planner.operations.converters.SqlCreateMaterializedTableConverter;
import org.apache.flink.table.planner.operations.converters.SqlCreateViewConverter;
import org.apache.flink.table.planner.operations.converters.SqlDescribeCatalogConverter;
import org.apache.flink.table.planner.operations.converters.SqlDescribeFunctionConverter;
import org.apache.flink.table.planner.operations.converters.SqlDescribeJobConverter;
import org.apache.flink.table.planner.operations.converters.SqlDropMaterializedTableConverter;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.operations.converters.SqlProcedureCallConverter;
import org.apache.flink.table.planner.operations.converters.SqlQueryConverter;
import org.apache.flink.table.planner.operations.converters.SqlReplaceTableAsConverter;
import org.apache.flink.table.planner.operations.converters.SqlShowCatalogsConverter;
import org.apache.flink.table.planner.operations.converters.SqlShowCreateCatalogConverter;
import org.apache.flink.table.planner.operations.converters.SqlShowDatabasesConverter;
import org.apache.flink.table.planner.operations.converters.SqlShowFunctionsConverter;
import org.apache.flink.table.planner.operations.converters.SqlShowPartitionsConverter;
import org.apache.flink.table.planner.operations.converters.SqlShowProcedureConverter;
import org.apache.flink.table.planner.operations.converters.SqlShowTablesConverter;
import org.apache.flink.table.planner.operations.converters.SqlShowViewsConverter;
import org.apache.flink.table.planner.operations.converters.SqlTruncateTableConverter;

public class SqlNodeConverters {
    private static final Map<Class<?>, SqlNodeConverter<?>> CLASS_CONVERTERS = new HashMap();
    private static final Map<SqlKind, SqlNodeConverter<?>> SQLKIND_CONVERTERS = new HashMap();

    public static Optional<Operation> convertSqlNode(SqlNode validatedSqlNode, SqlNodeConverter.ConvertContext context) {
        SqlNodeConverter<?> classConverter = CLASS_CONVERTERS.get(validatedSqlNode.getClass());
        if (classConverter != null) {
            return Optional.of(classConverter.convertSqlNode(validatedSqlNode, context));
        }
        SqlNodeConverter<?> sqlKindConverter = SQLKIND_CONVERTERS.get((Object)validatedSqlNode.getKind());
        if (sqlKindConverter != null) {
            return Optional.of(sqlKindConverter.convertSqlNode(validatedSqlNode, context));
        }
        return Optional.empty();
    }

    private static void register(SqlNodeConverter<?> converter) {
        if (converter.supportedSqlKinds().isPresent()) {
            for (SqlKind sqlKind : converter.supportedSqlKinds().get()) {
                if (SQLKIND_CONVERTERS.containsKey((Object)sqlKind)) {
                    throw new IllegalArgumentException(String.format("Failed to register converter for '%s', because there is a registered converter for the SqlKind '%s'", new Object[]{converter.getClass().getCanonicalName(), sqlKind}));
                }
                SQLKIND_CONVERTERS.put(sqlKind, converter);
            }
            return;
        }
        TypeInformation typeInfo = TypeExtractor.createTypeInfo(converter, SqlNodeConverter.class, converter.getClass(), (int)0);
        Class nodeClass = typeInfo.getTypeClass();
        if (CLASS_CONVERTERS.containsKey(nodeClass)) {
            throw new IllegalArgumentException(String.format("Failed to register converter for '%s', because there is a registered converter for the SqlNode '%s'", converter.getClass().getCanonicalName(), nodeClass.getCanonicalName()));
        }
        CLASS_CONVERTERS.put(nodeClass, converter);
    }

    static {
        SqlNodeConverters.register(new SqlCreateCatalogConverter());
        SqlNodeConverters.register(new SqlAlterCatalogOptionsConverter());
        SqlNodeConverters.register(new SqlAlterCatalogResetConverter());
        SqlNodeConverters.register(new SqlAlterCatalogCommentConverter());
        SqlNodeConverters.register(new SqlCreateViewConverter());
        SqlNodeConverters.register(new SqlAlterViewRenameConverter());
        SqlNodeConverters.register(new SqlAlterViewPropertiesConverter());
        SqlNodeConverters.register(new SqlAlterViewAsConverter());
        SqlNodeConverters.register(new SqlAlterTableAddPartitionConverter());
        SqlNodeConverters.register(new SqlAlterTableDropPartitionConverter());
        SqlNodeConverters.register(new SqlQueryConverter());
        SqlNodeConverters.register(new SqlShowPartitionsConverter());
        SqlNodeConverters.register(new SqlTruncateTableConverter());
        SqlNodeConverters.register(new SqlShowFunctionsConverter());
        SqlNodeConverters.register(new SqlShowProcedureConverter());
        SqlNodeConverters.register(new SqlReplaceTableAsConverter());
        SqlNodeConverters.register(new SqlProcedureCallConverter());
        SqlNodeConverters.register(new SqlShowDatabasesConverter());
        SqlNodeConverters.register(new SqlShowCreateCatalogConverter());
        SqlNodeConverters.register(new SqlDescribeCatalogConverter());
        SqlNodeConverters.register(new SqlDescribeJobConverter());
        SqlNodeConverters.register(new SqlCreateMaterializedTableConverter());
        SqlNodeConverters.register(new SqlAlterMaterializedTableRefreshConverter());
        SqlNodeConverters.register(new SqlAlterMaterializedTableSuspendConverter());
        SqlNodeConverters.register(new SqlAlterMaterializedTableResumeConverter());
        SqlNodeConverters.register(new SqlAlterMaterializedTableAsQueryConverter());
        SqlNodeConverters.register(new SqlDropMaterializedTableConverter());
        SqlNodeConverters.register(new SqlShowTablesConverter());
        SqlNodeConverters.register(new SqlShowViewsConverter());
        SqlNodeConverters.register(new SqlShowCatalogsConverter());
        SqlNodeConverters.register(new SqlDescribeFunctionConverter());
    }
}

