/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.multipleinput;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.operators.BoundedMultiInput;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeServiceAware;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Preconditions;

public class TableOperatorWrapper<OP extends StreamOperator<RowData>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final StreamOperatorFactory<RowData> factory;
    private final String operatorName;
    private final List<TypeInformation<?>> allInputTypes;
    private final TypeInformation<?> outputType;
    private double managedMemoryFraction = -1.0;
    private final List<Edge> inputEdges;
    private final List<Edge> outputEdges;
    private transient OP wrapped;
    private boolean closed;
    private int endedInputCount;

    public TableOperatorWrapper(StreamOperatorFactory<RowData> factory, String operatorName, List<TypeInformation<?>> allInputTypes, TypeInformation<?> outputType) {
        this.factory = (StreamOperatorFactory)Preconditions.checkNotNull(factory);
        this.operatorName = (String)Preconditions.checkNotNull((Object)operatorName);
        this.outputType = (TypeInformation)Preconditions.checkNotNull(outputType);
        this.allInputTypes = (List)Preconditions.checkNotNull(allInputTypes);
        this.inputEdges = new ArrayList<Edge>();
        this.outputEdges = new ArrayList<Edge>();
        this.endedInputCount = 0;
    }

    public void createOperator(StreamOperatorParameters<RowData> parameters) {
        Preconditions.checkArgument((this.wrapped == null ? 1 : 0) != 0, (Object)"This operator has been initialized");
        if (this.factory instanceof ProcessingTimeServiceAware) {
            ((ProcessingTimeServiceAware)this.factory).setProcessingTimeService(parameters.getProcessingTimeService());
        }
        this.wrapped = this.factory.createStreamOperator(parameters);
    }

    public void endOperatorInput(int inputId) throws Exception {
        ++this.endedInputCount;
        if (this.wrapped instanceof BoundedOneInput) {
            ((BoundedOneInput)this.wrapped).endInput();
            this.propagateEndOperatorInput();
        } else if (this.wrapped instanceof BoundedMultiInput) {
            ((BoundedMultiInput)this.wrapped).endInput(inputId);
            if (this.endedInputCount >= this.allInputTypes.size()) {
                this.propagateEndOperatorInput();
            }
        } else {
            this.propagateEndOperatorInput();
        }
    }

    private void propagateEndOperatorInput() throws Exception {
        for (Edge edge : this.outputEdges) {
            edge.target.endOperatorInput(edge.inputId);
        }
    }

    public OP getStreamOperator() {
        return (OP)((StreamOperator)Preconditions.checkNotNull(this.wrapped));
    }

    public List<TypeInformation<?>> getAllInputTypes() {
        return this.allInputTypes;
    }

    public TypeInformation<?> getOutputType() {
        return this.outputType;
    }

    public void addInput(TableOperatorWrapper<?> input, int inputId) {
        Preconditions.checkArgument((inputId > 0 && inputId <= this.getAllInputTypes().size() ? 1 : 0) != 0);
        Edge edge = new Edge(input, this, inputId);
        this.inputEdges.add(edge);
        input.outputEdges.add(edge);
    }

    public void setManagedMemoryFraction(double managedMemoryFraction) {
        this.managedMemoryFraction = managedMemoryFraction;
    }

    public double getManagedMemoryFraction() {
        return this.managedMemoryFraction;
    }

    public List<Edge> getInputEdges() {
        return this.inputEdges;
    }

    public List<TableOperatorWrapper<?>> getInputWrappers() {
        return this.inputEdges.stream().map(Edge::getSource).collect(Collectors.toList());
    }

    public List<Edge> getOutputEdges() {
        return this.outputEdges;
    }

    public List<TableOperatorWrapper<?>> getOutputWrappers() {
        return this.outputEdges.stream().map(Edge::getTarget).collect(Collectors.toList());
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() throws Exception {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        this.wrapped.close();
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    @VisibleForTesting
    public int getEndedInputCount() {
        return this.endedInputCount;
    }

    public boolean equals(Object o) {
        int i;
        boolean b;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableOperatorWrapper other = (TableOperatorWrapper)o;
        boolean bl = b = Double.compare(other.managedMemoryFraction, this.managedMemoryFraction) == 0 && this.factory.equals(other.factory) && this.operatorName.equals(other.operatorName) && this.allInputTypes.equals(other.allInputTypes) && this.outputType.equals(other.outputType) && this.inputEdges.size() == other.inputEdges.size() && this.outputEdges.size() == other.outputEdges.size();
        if (b) {
            return true;
        }
        for (i = 0; i < this.inputEdges.size(); ++i) {
            if (this.inputEdges.get(i).toString().equals(other.inputEdges.get(i).toString())) continue;
            return false;
        }
        for (i = 0; i < this.outputEdges.size(); ++i) {
            if (this.outputEdges.get(i).toString().equals(other.outputEdges.get(i).toString())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.factory, this.operatorName, this.allInputTypes, this.outputType, this.managedMemoryFraction, this.inputEdges);
    }

    public String toString() {
        return this.operatorName;
    }

    public static class Edge
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final TableOperatorWrapper<?> source;
        private final TableOperatorWrapper<?> target;
        private final int inputId;

        public Edge(TableOperatorWrapper<?> source, TableOperatorWrapper<?> target, int inputId) {
            this.source = (TableOperatorWrapper)Preconditions.checkNotNull(source);
            this.target = (TableOperatorWrapper)Preconditions.checkNotNull(target);
            this.inputId = inputId;
        }

        public TableOperatorWrapper<?> getSource() {
            return this.source;
        }

        public TableOperatorWrapper<?> getTarget() {
            return this.target;
        }

        public int getInputId() {
            return this.inputId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Edge edge = (Edge)o;
            return this.inputId == edge.inputId && this.source.equals(edge.source) && this.target.equals(edge.target);
        }

        public int hashCode() {
            return Objects.hash(this.source, this.target, this.inputId);
        }

        public String toString() {
            return "Edge{source=" + this.source + ", target=" + this.target + ", inputId=" + this.inputId + "}";
        }
    }
}

