/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.binary;

import java.lang.reflect.Array;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemoryUtils;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinarySection;
import org.apache.flink.table.data.binary.BinarySegmentUtils;
import org.apache.flink.table.data.binary.TypedSetters;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;
import org.apache.flink.types.variant.Variant;

@Internal
public final class BinaryArrayData
extends BinarySection
implements ArrayData,
TypedSetters {
    private static final int BYTE_ARRAY_BASE_OFFSET = MemoryUtils.UNSAFE.arrayBaseOffset(byte[].class);
    private static final int BOOLEAN_ARRAY_OFFSET = MemoryUtils.UNSAFE.arrayBaseOffset(boolean[].class);
    private static final int SHORT_ARRAY_OFFSET = MemoryUtils.UNSAFE.arrayBaseOffset(short[].class);
    private static final int INT_ARRAY_OFFSET = MemoryUtils.UNSAFE.arrayBaseOffset(int[].class);
    private static final int LONG_ARRAY_OFFSET = MemoryUtils.UNSAFE.arrayBaseOffset(long[].class);
    private static final int FLOAT_ARRAY_OFFSET = MemoryUtils.UNSAFE.arrayBaseOffset(float[].class);
    private static final int DOUBLE_ARRAY_OFFSET = MemoryUtils.UNSAFE.arrayBaseOffset(double[].class);
    private int size;
    private int elementOffset;

    public static int calculateHeaderInBytes(int numFields) {
        return 4 + (numFields + 31) / 32 * 4;
    }

    public static int calculateFixLengthPartSize(LogicalType type) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: 
            case TINYINT: {
                return 1;
            }
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: 
            case DECIMAL: 
            case BIGINT: 
            case DOUBLE: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case INTERVAL_DAY_TIME: 
            case ARRAY: 
            case MULTISET: 
            case MAP: 
            case ROW: 
            case STRUCTURED_TYPE: 
            case RAW: 
            case VARIANT: {
                return 8;
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                throw new UnsupportedOperationException();
            }
            case SMALLINT: {
                return 2;
            }
            case INTEGER: 
            case FLOAT: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case INTERVAL_YEAR_MONTH: {
                return 4;
            }
            case DISTINCT_TYPE: {
                return BinaryArrayData.calculateFixLengthPartSize(((DistinctType)type).getSourceType());
            }
        }
        throw new IllegalArgumentException();
    }

    private void assertIndexIsValid(int ordinal) {
        assert (ordinal >= 0) : "ordinal (" + ordinal + ") should >= 0";
        assert (ordinal < this.size) : "ordinal (" + ordinal + ") should < " + this.size;
    }

    private int getElementOffset(int ordinal, int elementSize) {
        return this.elementOffset + ordinal * elementSize;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void pointTo(MemorySegment[] segments, int offset, int sizeInBytes) {
        int size = BinarySegmentUtils.getInt(segments, offset);
        assert (size >= 0) : "size (" + size + ") should >= 0";
        this.size = size;
        this.segments = segments;
        this.offset = offset;
        this.sizeInBytes = sizeInBytes;
        this.elementOffset = offset + BinaryArrayData.calculateHeaderInBytes(this.size);
    }

    @Override
    public boolean isNullAt(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.bitGet(this.segments, this.offset + 4, pos);
    }

    @Override
    public void setNullAt(int pos) {
        this.assertIndexIsValid(pos);
        BinarySegmentUtils.bitSet(this.segments, this.offset + 4, pos);
    }

    public void setNotNullAt(int pos) {
        this.assertIndexIsValid(pos);
        BinarySegmentUtils.bitUnSet(this.segments, this.offset + 4, pos);
    }

    @Override
    public long getLong(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.getLong(this.segments, this.getElementOffset(pos, 8));
    }

    @Override
    public void setLong(int pos, long value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        BinarySegmentUtils.setLong(this.segments, this.getElementOffset(pos, 8), value);
    }

    public void setNullLong(int pos) {
        this.assertIndexIsValid(pos);
        BinarySegmentUtils.bitSet(this.segments, this.offset + 4, pos);
        BinarySegmentUtils.setLong(this.segments, this.getElementOffset(pos, 8), 0L);
    }

    @Override
    public int getInt(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.getInt(this.segments, this.getElementOffset(pos, 4));
    }

    @Override
    public void setInt(int pos, int value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        BinarySegmentUtils.setInt(this.segments, this.getElementOffset(pos, 4), value);
    }

    public void setNullInt(int pos) {
        this.assertIndexIsValid(pos);
        BinarySegmentUtils.bitSet(this.segments, this.offset + 4, pos);
        BinarySegmentUtils.setInt(this.segments, this.getElementOffset(pos, 4), 0);
    }

    @Override
    public StringData getString(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getElementOffset(pos, 8);
        long offsetAndSize = BinarySegmentUtils.getLong(this.segments, fieldOffset);
        return BinarySegmentUtils.readStringData(this.segments, this.offset, fieldOffset, offsetAndSize);
    }

    @Override
    public DecimalData getDecimal(int pos, int precision, int scale) {
        this.assertIndexIsValid(pos);
        if (DecimalData.isCompact(precision)) {
            return DecimalData.fromUnscaledLong(BinarySegmentUtils.getLong(this.segments, this.getElementOffset(pos, 8)), precision, scale);
        }
        int fieldOffset = this.getElementOffset(pos, 8);
        long offsetAndSize = BinarySegmentUtils.getLong(this.segments, fieldOffset);
        return BinarySegmentUtils.readDecimalData(this.segments, this.offset, offsetAndSize, precision, scale);
    }

    @Override
    public TimestampData getTimestamp(int pos, int precision) {
        this.assertIndexIsValid(pos);
        if (TimestampData.isCompact(precision)) {
            return TimestampData.fromEpochMillis(BinarySegmentUtils.getLong(this.segments, this.getElementOffset(pos, 8)));
        }
        int fieldOffset = this.getElementOffset(pos, 8);
        long offsetAndNanoOfMilli = BinarySegmentUtils.getLong(this.segments, fieldOffset);
        return BinarySegmentUtils.readTimestampData(this.segments, this.offset, offsetAndNanoOfMilli);
    }

    @Override
    public <T> RawValueData<T> getRawValue(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getElementOffset(pos, 8);
        long offsetAndSize = BinarySegmentUtils.getLong(this.segments, fieldOffset);
        return BinarySegmentUtils.readRawValueData(this.segments, this.offset, offsetAndSize);
    }

    @Override
    public Variant getVariant(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getElementOffset(pos, 8);
        long offsetAndSize = BinarySegmentUtils.getLong(this.segments, fieldOffset);
        return BinarySegmentUtils.readVariant(this.segments, this.offset, offsetAndSize);
    }

    @Override
    public byte[] getBinary(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getElementOffset(pos, 8);
        long offsetAndSize = BinarySegmentUtils.getLong(this.segments, fieldOffset);
        return BinarySegmentUtils.readBinary(this.segments, this.offset, fieldOffset, offsetAndSize);
    }

    @Override
    public ArrayData getArray(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.readArrayData(this.segments, this.offset, this.getLong(pos));
    }

    @Override
    public MapData getMap(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.readMapData(this.segments, this.offset, this.getLong(pos));
    }

    @Override
    public RowData getRow(int pos, int numFields) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getElementOffset(pos, 8);
        long offsetAndSize = BinarySegmentUtils.getLong(this.segments, fieldOffset);
        return BinarySegmentUtils.readRowData(this.segments, numFields, this.offset, offsetAndSize);
    }

    @Override
    public boolean getBoolean(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.getBoolean(this.segments, this.getElementOffset(pos, 1));
    }

    @Override
    public void setBoolean(int pos, boolean value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        BinarySegmentUtils.setBoolean(this.segments, this.getElementOffset(pos, 1), value);
    }

    public void setNullBoolean(int pos) {
        this.assertIndexIsValid(pos);
        BinarySegmentUtils.bitSet(this.segments, this.offset + 4, pos);
        BinarySegmentUtils.setBoolean(this.segments, this.getElementOffset(pos, 1), false);
    }

    @Override
    public byte getByte(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.getByte(this.segments, this.getElementOffset(pos, 1));
    }

    @Override
    public void setByte(int pos, byte value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        BinarySegmentUtils.setByte(this.segments, this.getElementOffset(pos, 1), value);
    }

    public void setNullByte(int pos) {
        this.assertIndexIsValid(pos);
        BinarySegmentUtils.bitSet(this.segments, this.offset + 4, pos);
        BinarySegmentUtils.setByte(this.segments, this.getElementOffset(pos, 1), (byte)0);
    }

    @Override
    public short getShort(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.getShort(this.segments, this.getElementOffset(pos, 2));
    }

    @Override
    public void setShort(int pos, short value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        BinarySegmentUtils.setShort(this.segments, this.getElementOffset(pos, 2), value);
    }

    public void setNullShort(int pos) {
        this.assertIndexIsValid(pos);
        BinarySegmentUtils.bitSet(this.segments, this.offset + 4, pos);
        BinarySegmentUtils.setShort(this.segments, this.getElementOffset(pos, 2), (short)0);
    }

    @Override
    public float getFloat(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.getFloat(this.segments, this.getElementOffset(pos, 4));
    }

    @Override
    public void setFloat(int pos, float value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        BinarySegmentUtils.setFloat(this.segments, this.getElementOffset(pos, 4), value);
    }

    public void setNullFloat(int pos) {
        this.assertIndexIsValid(pos);
        BinarySegmentUtils.bitSet(this.segments, this.offset + 4, pos);
        BinarySegmentUtils.setFloat(this.segments, this.getElementOffset(pos, 4), 0.0f);
    }

    @Override
    public double getDouble(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.getDouble(this.segments, this.getElementOffset(pos, 8));
    }

    @Override
    public void setDouble(int pos, double value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        BinarySegmentUtils.setDouble(this.segments, this.getElementOffset(pos, 8), value);
    }

    public void setNullDouble(int pos) {
        this.assertIndexIsValid(pos);
        BinarySegmentUtils.bitSet(this.segments, this.offset + 4, pos);
        BinarySegmentUtils.setDouble(this.segments, this.getElementOffset(pos, 8), 0.0);
    }

    @Override
    public void setDecimal(int pos, DecimalData value, int precision) {
        this.assertIndexIsValid(pos);
        if (DecimalData.isCompact(precision)) {
            this.setLong(pos, value.toUnscaledLong());
        } else {
            int fieldOffset = this.getElementOffset(pos, 8);
            int cursor = (int)(BinarySegmentUtils.getLong(this.segments, fieldOffset) >>> 32);
            assert (cursor > 0) : "invalid cursor " + cursor;
            BinarySegmentUtils.setLong(this.segments, this.offset + cursor, 0L);
            BinarySegmentUtils.setLong(this.segments, this.offset + cursor + 8, 0L);
            if (value == null) {
                this.setNullAt(pos);
                BinarySegmentUtils.setLong(this.segments, fieldOffset, (long)cursor << 32);
            } else {
                byte[] bytes = value.toUnscaledBytes();
                assert (bytes.length <= 16);
                BinarySegmentUtils.copyFromBytes(this.segments, this.offset + cursor, bytes, 0, bytes.length);
                this.setLong(pos, (long)cursor << 32 | (long)bytes.length);
            }
        }
    }

    @Override
    public void setTimestamp(int pos, TimestampData value, int precision) {
        this.assertIndexIsValid(pos);
        if (TimestampData.isCompact(precision)) {
            this.setLong(pos, value.getMillisecond());
        } else {
            int fieldOffset = this.getElementOffset(pos, 8);
            int cursor = (int)(BinarySegmentUtils.getLong(this.segments, fieldOffset) >>> 32);
            assert (cursor > 0) : "invalid cursor " + cursor;
            if (value == null) {
                this.setNullAt(pos);
                BinarySegmentUtils.setLong(this.segments, this.offset + cursor, 0L);
                BinarySegmentUtils.setLong(this.segments, fieldOffset, (long)cursor << 32);
            } else {
                BinarySegmentUtils.setLong(this.segments, this.offset + cursor, value.getMillisecond());
                this.setLong(pos, (long)cursor << 32 | (long)value.getNanoOfMillisecond());
            }
        }
    }

    public boolean anyNull() {
        for (int i = this.offset + 4; i < this.elementOffset; i += 4) {
            if (BinarySegmentUtils.getInt(this.segments, i) == 0) continue;
            return true;
        }
        return false;
    }

    private void checkNoNull() {
        if (this.anyNull()) {
            throw new RuntimeException("Primitive array must not contain a null value.");
        }
    }

    @Override
    public boolean[] toBooleanArray() {
        this.checkNoNull();
        boolean[] values = new boolean[this.size];
        BinarySegmentUtils.copyToUnsafe(this.segments, this.elementOffset, values, BOOLEAN_ARRAY_OFFSET, this.size);
        return values;
    }

    @Override
    public byte[] toByteArray() {
        this.checkNoNull();
        byte[] values = new byte[this.size];
        BinarySegmentUtils.copyToUnsafe(this.segments, this.elementOffset, values, BYTE_ARRAY_BASE_OFFSET, this.size);
        return values;
    }

    @Override
    public short[] toShortArray() {
        this.checkNoNull();
        short[] values = new short[this.size];
        BinarySegmentUtils.copyToUnsafe(this.segments, this.elementOffset, values, SHORT_ARRAY_OFFSET, this.size * 2);
        return values;
    }

    @Override
    public int[] toIntArray() {
        this.checkNoNull();
        int[] values = new int[this.size];
        BinarySegmentUtils.copyToUnsafe(this.segments, this.elementOffset, values, INT_ARRAY_OFFSET, this.size * 4);
        return values;
    }

    @Override
    public long[] toLongArray() {
        this.checkNoNull();
        long[] values = new long[this.size];
        BinarySegmentUtils.copyToUnsafe(this.segments, this.elementOffset, values, LONG_ARRAY_OFFSET, this.size * 8);
        return values;
    }

    @Override
    public float[] toFloatArray() {
        this.checkNoNull();
        float[] values = new float[this.size];
        BinarySegmentUtils.copyToUnsafe(this.segments, this.elementOffset, values, FLOAT_ARRAY_OFFSET, this.size * 4);
        return values;
    }

    @Override
    public double[] toDoubleArray() {
        this.checkNoNull();
        double[] values = new double[this.size];
        BinarySegmentUtils.copyToUnsafe(this.segments, this.elementOffset, values, DOUBLE_ARRAY_OFFSET, this.size * 8);
        return values;
    }

    public <T> T[] toObjectArray(LogicalType elementType) {
        Class<?> elementClass = LogicalTypeUtils.toInternalConversionClass(elementType);
        ArrayData.ElementGetter elementGetter = ArrayData.createElementGetter(elementType);
        Object[] values = (Object[])Array.newInstance(elementClass, this.size);
        for (int i = 0; i < this.size; ++i) {
            if (this.isNullAt(i)) continue;
            values[i] = elementGetter.getElementOrNull(this, i);
        }
        return values;
    }

    public BinaryArrayData copy() {
        return this.copy(new BinaryArrayData());
    }

    public BinaryArrayData copy(BinaryArrayData reuse) {
        byte[] bytes = BinarySegmentUtils.copyToBytes(this.segments, this.offset, this.sizeInBytes);
        reuse.pointTo(MemorySegmentFactory.wrap((byte[])bytes), 0, this.sizeInBytes);
        return reuse;
    }

    @Override
    public int hashCode() {
        return BinarySegmentUtils.hashByWords(this.segments, this.offset, this.sizeInBytes);
    }

    public static BinaryArrayData fromPrimitiveArray(boolean[] arr) {
        return BinaryArrayData.fromPrimitiveArray(arr, BOOLEAN_ARRAY_OFFSET, arr.length, 1);
    }

    public static BinaryArrayData fromPrimitiveArray(byte[] arr) {
        return BinaryArrayData.fromPrimitiveArray(arr, BYTE_ARRAY_BASE_OFFSET, arr.length, 1);
    }

    public static BinaryArrayData fromPrimitiveArray(short[] arr) {
        return BinaryArrayData.fromPrimitiveArray(arr, SHORT_ARRAY_OFFSET, arr.length, 2);
    }

    public static BinaryArrayData fromPrimitiveArray(int[] arr) {
        return BinaryArrayData.fromPrimitiveArray(arr, INT_ARRAY_OFFSET, arr.length, 4);
    }

    public static BinaryArrayData fromPrimitiveArray(long[] arr) {
        return BinaryArrayData.fromPrimitiveArray(arr, LONG_ARRAY_OFFSET, arr.length, 8);
    }

    public static BinaryArrayData fromPrimitiveArray(float[] arr) {
        return BinaryArrayData.fromPrimitiveArray(arr, FLOAT_ARRAY_OFFSET, arr.length, 4);
    }

    public static BinaryArrayData fromPrimitiveArray(double[] arr) {
        return BinaryArrayData.fromPrimitiveArray(arr, DOUBLE_ARRAY_OFFSET, arr.length, 8);
    }

    private static BinaryArrayData fromPrimitiveArray(Object arr, int offset, int length, int elementSize) {
        long valueRegionInBytes;
        long headerInBytes = BinaryArrayData.calculateHeaderInBytes(length);
        long totalSizeInLongs = (headerInBytes + (valueRegionInBytes = (long)(elementSize * length)) + 7L) / 8L;
        if (totalSizeInLongs > 0xFFFFFFFL) {
            throw new UnsupportedOperationException("Cannot convert this array to unsafe format as it's too big.");
        }
        long totalSize = totalSizeInLongs * 8L;
        byte[] data = new byte[(int)totalSize];
        MemoryUtils.UNSAFE.putInt(data, BYTE_ARRAY_BASE_OFFSET, length);
        MemoryUtils.UNSAFE.copyMemory(arr, offset, data, (long)BYTE_ARRAY_BASE_OFFSET + headerInBytes, valueRegionInBytes);
        BinaryArrayData result = new BinaryArrayData();
        result.pointTo(MemorySegmentFactory.wrap((byte[])data), 0, (int)totalSize);
        return result;
    }
}

