/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm.io;

import com.aliyun.oss.common.utils.LogUtils;
import java.io.IOException;
import java.io.InputStream;

public class RepeatableInputStream
extends InputStream {
    private InputStream is = null;
    private int bufferSize = 0;
    private int bufferOffset = 0;
    private long bytesReadFromMark = 0L;
    private byte[] buffer = null;

    public RepeatableInputStream(InputStream inputStream, int bufferSize) {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream should not be null");
        }
        this.is = inputStream;
        this.bufferSize = bufferSize;
        this.buffer = new byte[this.bufferSize];
    }

    @Override
    public void reset() throws IOException {
        if (this.bytesReadFromMark > (long)this.bufferSize) {
            throw new IOException("Input stream cannot be reset as " + this.bytesReadFromMark + " bytes have been written, exceeding the available buffer size of " + this.bufferSize);
        }
        LogUtils.getLog().debug("Reset after reading " + this.bytesReadFromMark + " bytes.");
        this.bufferOffset = 0;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this.bytesReadFromMark <= (long)this.bufferSize && this.buffer != null) {
            byte[] newBuffer = new byte[this.bufferSize];
            System.arraycopy(this.buffer, this.bufferOffset, newBuffer, 0, (int)(this.bytesReadFromMark - (long)this.bufferOffset));
            this.buffer = newBuffer;
            this.bytesReadFromMark -= (long)this.bufferOffset;
            this.bufferOffset = 0;
        } else {
            this.bufferOffset = 0;
            this.bytesReadFromMark = 0L;
            this.buffer = new byte[this.bufferSize];
        }
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public int read(byte[] out, int outOffset, int outLength) throws IOException {
        byte[] tmp = new byte[outLength];
        if ((long)this.bufferOffset < this.bytesReadFromMark && this.buffer != null) {
            int bytesFromBuffer = tmp.length;
            if ((long)(this.bufferOffset + bytesFromBuffer) > this.bytesReadFromMark) {
                bytesFromBuffer = (int)this.bytesReadFromMark - this.bufferOffset;
            }
            System.arraycopy(this.buffer, this.bufferOffset, out, outOffset, bytesFromBuffer);
            this.bufferOffset += bytesFromBuffer;
            return bytesFromBuffer;
        }
        int count = this.is.read(tmp);
        if (count <= 0) {
            return count;
        }
        if (this.bytesReadFromMark + (long)count <= (long)this.bufferSize) {
            System.arraycopy(tmp, 0, this.buffer, (int)this.bytesReadFromMark, count);
            this.bufferOffset += count;
        } else if (this.buffer != null) {
            LogUtils.getLog().debug("Buffer size " + this.bufferSize + " has been exceeded and the input stream will not be repeatable until the next mark. Freeing buffer memory");
            this.buffer = null;
        }
        System.arraycopy(tmp, 0, out, outOffset, count);
        this.bytesReadFromMark += (long)count;
        return count;
    }

    @Override
    public int read() throws IOException {
        byte[] tmp = new byte[1];
        int count = this.read(tmp);
        if (count != -1) {
            return tmp[0];
        }
        return count;
    }

    public InputStream getWrappedInputStream() {
        return this.is;
    }
}

