/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.query.RegionNotFoundException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheForClientAccess;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.classloader.ClassPathLoader;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.security.AuthenticationRequiredException;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.subject.Subject;

public class UserFunctionExecution
implements InternalFunction<Object[]> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogService.getLogger();
    protected static final String ID = "org.apache.geode.management.internal.cli.functions.UserFunctionExecution";

    public String getId() {
        return ID;
    }

    public boolean isHA() {
        return false;
    }

    public Collection<ResourcePermission> getRequiredPermissions(String regionName) {
        return Collections.emptySet();
    }

    boolean loginRequired(SecurityService securityService) {
        try {
            Subject subject = securityService.getSubject();
            return subject == null || !subject.isAuthenticated();
        }
        catch (AuthenticationRequiredException e) {
            return true;
        }
    }

    Function<?> loadFunction(String functionId) {
        return FunctionService.getFunction((String)functionId);
    }

    String[] parseArguments(String argumentsString) {
        if (argumentsString != null && argumentsString.length() > 0) {
            return argumentsString.split(",");
        }
        return null;
    }

    Set<String> parseFilters(String filterString) {
        if (filterString != null && filterString.length() > 0) {
            return Arrays.stream(filterString.split(",")).collect(Collectors.toSet());
        }
        return new HashSet<String>();
    }

    ResultCollector<Object, List<Object>> parseResultCollector(String resultCollectorName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (resultCollectorName != null && resultCollectorName.length() > 0) {
            return (ResultCollector)ClassPathLoader.getLatest().forName(resultCollectorName).newInstance();
        }
        return null;
    }

    Execution<Object, Object, List<Object>> buildExecution(Cache cache, String onRegion) throws RegionNotFoundException {
        Execution execution;
        DistributedMember member = cache.getDistributedSystem().getDistributedMember();
        if (onRegion != null && onRegion.length() > 0) {
            Region region = cache.getRegion(onRegion);
            if (region == null) {
                throw new RegionNotFoundException(onRegion);
            }
            execution = FunctionService.onRegion((Region)region);
        } else {
            execution = FunctionService.onMember((DistributedMember)member);
        }
        return execution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FunctionContext<Object[]> context) {
        InternalCacheForClientAccess cache = ((InternalCache)context.getCache()).getCacheForProcessingClientRequests();
        DistributedMember member = cache.getDistributedSystem().getDistributedMember();
        Object[] args = (Object[])context.getArguments();
        if (args == null) {
            context.getResultSender().lastResult((Object)new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, "Could not retrieve arguments"));
            return;
        }
        String functionId = (String)args[0];
        String filterString = (String)args[1];
        String resultCollectorName = (String)args[2];
        String argumentsString = (String)args[3];
        String onRegion = (String)args[4];
        Properties credentials = (Properties)args[5];
        SecurityService securityService = ((InternalCache)context.getCache()).getSecurityService();
        boolean loginSuccessful = false;
        try {
            Function<?> function;
            if (this.loginRequired(securityService)) {
                securityService.login(credentials);
                loginSuccessful = true;
            }
            if ((function = this.loadFunction(functionId)) == null) {
                context.getResultSender().lastResult((Object)new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, CliStrings.format((String)"Function : {0} is not registered on member.", (Object)functionId)));
                return;
            }
            Set<String> filters = this.parseFilters(filterString);
            String[] functionArgs = this.parseArguments(argumentsString);
            ResultCollector<Object, List<Object>> resultCollectorInstance = this.parseResultCollector(resultCollectorName);
            function.getRequiredPermissions(onRegion, (Object)functionArgs).forEach(arg_0 -> ((SecurityService)securityService).authorize(arg_0));
            Execution execution = this.buildExecution((Cache)cache, onRegion);
            if (execution == null) {
                context.getResultSender().lastResult((Object)new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, CliStrings.format((String)"While executing function : {0} on member : {1} one region : {2} error occurred : {3}", (Object[])new Object[]{functionId, member.getId(), onRegion, "Could not retrieve executor"})));
                return;
            }
            if (resultCollectorInstance != null) {
                execution = execution.withCollector(resultCollectorInstance);
            }
            if (functionArgs != null && functionArgs.length > 0) {
                execution = execution.setArguments((Object)functionArgs);
            }
            if (filters.size() > 0) {
                execution = execution.withFilter(filters);
            }
            List results = null;
            boolean functionSuccess = true;
            ArrayList<String> resultMessage = new ArrayList<String>();
            ResultCollector rc = execution.execute(function.getId());
            if (function.hasResult()) {
                results = (List)rc.getResult();
            }
            if (results != null) {
                for (Object resultObj : results) {
                    if (resultObj == null) continue;
                    if (resultObj instanceof Exception) {
                        resultMessage.add(((Exception)resultObj).getMessage());
                        functionSuccess = false;
                        continue;
                    }
                    resultMessage.add(resultObj.toString());
                }
            }
            context.getResultSender().lastResult((Object)new CliFunctionResult(context.getMemberName(), functionSuccess ? CliFunctionResult.StatusState.OK : CliFunctionResult.StatusState.ERROR, ((Object)resultMessage).toString()));
        }
        catch (RegionNotFoundException regionNotFoundException) {
            context.getResultSender().lastResult((Object)new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, onRegion + " does not exist"));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            context.getResultSender().lastResult((Object)new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, CliStrings.format((String)"ResultCollector : {0} not found. Error : {1}", (Object[])new Object[]{resultCollectorName, e.getMessage()})));
        }
        catch (Exception e) {
            logger.error("error executing function " + functionId, (Throwable)e);
            context.getResultSender().lastResult((Object)new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, "Exception: " + e.getMessage()));
        }
        finally {
            if (loginSuccessful) {
                securityService.logout();
            }
        }
    }
}

