/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.result;

import java.util.function.Supplier;
import org.apache.geode.management.internal.cli.shell.Gfsh;

class Screen {
    private static final String GFSH_TRIMSCRWIDTH_PROPERTY = "GFSH.TRIMSCRWIDTH";
    private final Supplier<Gfsh> gfshCurrentInstanceSupplier;

    Screen() {
        this(Gfsh::getCurrentInstance);
    }

    private Screen(Supplier<Gfsh> gfshCurrentInstanceSupplier) {
        this.gfshCurrentInstanceSupplier = gfshCurrentInstanceSupplier;
    }

    int trimWidthForScreen(int maxColLength) {
        if (this.shouldTrimColumns()) {
            int screenWidth = this.getScreenWidth();
            return Math.min(maxColLength, screenWidth);
        }
        return maxColLength;
    }

    int getScreenWidth() {
        Gfsh gfsh = this.gfshCurrentInstanceSupplier.get();
        if (gfsh == null) {
            return 100;
        }
        return gfsh.getTerminalWidth();
    }

    boolean shouldTrimColumns() {
        Gfsh gfsh = this.gfshCurrentInstanceSupplier.get();
        if (gfsh == null) {
            return Boolean.getBoolean(GFSH_TRIMSCRWIDTH_PROPERTY);
        }
        return "basic".equals(gfsh.getEnvProperty("APP_RESULT_VIEWER")) && !Gfsh.isInfoResult();
    }
}

