/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.jmx.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.geode.GemFireException;
import org.apache.geode.SystemFailure;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.jmx.Agent;
import org.apache.geode.admin.jmx.AgentFactory;
import org.apache.geode.admin.jmx.internal.AgentConfigImpl;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.internal.ExitCode;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.internal.util.JavaCommandBuilder;
import org.apache.geode.logging.internal.OSProcess;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

@Deprecated
public class AgentLauncher {
    private static final Logger logger = LogService.getLogger();
    public static final boolean PRINT_LAUNCH_COMMAND = Boolean.getBoolean(AgentLauncher.class.getSimpleName() + ".PRINT_LAUNCH_COMMAND");
    static final int SHUTDOWN = 0;
    static final int STARTING = 1;
    static final int RUNNING = 2;
    static final int SHUTDOWN_PENDING = 3;
    static final int SHUTDOWN_PENDING_AFTER_FAILED_STARTUP = 4;
    static final int UNKNOWN = 6;
    static final String AGENT_PROPS = "agent-props";
    static final String APPENDTO_LOG_FILE = "appendto-log-file";
    static final String CLASSPATH = "classpath";
    static final String DIR = "dir";
    static final String VMARGS = "vmargs";
    private File workingDirectory = null;
    private Status status = null;
    private final String basename;
    private final String startLogFileName;
    private final String statusFileName;

    AgentLauncher(String basename) {
        assert (basename != null) : "The base name used by the AgentLauncher to create files cannot be null!";
        this.basename = basename;
        String formattedBasename = this.basename.toLowerCase().replace(" ", "");
        this.startLogFileName = "start_" + formattedBasename + ".log";
        this.statusFileName = "." + formattedBasename + ".ser";
    }

    public void configHelp() {
        String prop;
        PrintStream out = System.out;
        Properties props = AgentConfigImpl.getDefaultValuesForAllProperties();
        out.println("\n");
        out.println("Agent configuration properties");
        TreeMap<String, String> map = new TreeMap<String, String>();
        int maxLength = 0;
        for (Object object : props.keySet()) {
            prop = (String)object;
            int length = prop.length();
            if (length > maxLength) {
                maxLength = length;
            }
            map.put(prop, AgentConfigImpl.getPropertyDescription(prop) + " (Default  \"" + props.getProperty(prop) + "\")");
        }
        for (Map.Entry entry : map.entrySet()) {
            prop = (String)entry.getKey();
            out.print("  ");
            out.println(prop);
            String description = (String)entry.getValue();
            StringTokenizer st = new StringTokenizer(description, " ");
            out.print("    ");
            int printed = 6;
            while (st.hasMoreTokens()) {
                String word = st.nextToken();
                if (printed + word.length() > 72) {
                    out.print("\n    ");
                    printed = 6;
                }
                out.print(word);
                out.print(" ");
                printed += word.length() + 1;
            }
            out.println();
        }
        out.println();
        ExitCode.FATAL.doSystemExit();
    }

    protected Map<String, Object> getStartOptions(String[] args) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put(APPENDTO_LOG_FILE, "false");
        options.put(DIR, IOUtils.tryGetCanonicalFileElseGetAbsoluteFile(new File(".")));
        ArrayList<String> vmArgs = new ArrayList<String>();
        options.put(VMARGS, vmArgs);
        Properties agentProps = new Properties();
        options.put(AGENT_PROPS, agentProps);
        for (String arg : args) {
            if (arg.startsWith("-classpath=")) {
                options.put(CLASSPATH, arg.substring("-classpath=".length()));
                continue;
            }
            if (arg.startsWith("-dir=")) {
                File workingDirectory = AgentLauncher.processDirOption(options, arg.substring("-dir=".length()));
                System.setProperty("gfAgentPropertyFile", new File(workingDirectory, "agent.properties").getPath());
                continue;
            }
            if (arg.startsWith("-J")) {
                vmArgs.add(arg.substring(2));
                continue;
            }
            if (!arg.contains("=")) continue;
            int index = arg.indexOf("=");
            String prop = arg.substring(0, index);
            String value = arg.substring(index + 1);
            if (prop.equals(APPENDTO_LOG_FILE)) {
                options.put(APPENDTO_LOG_FILE, value);
                continue;
            }
            AgentConfigImpl.getPropertyDescription(prop);
            if ("property-file".equals(prop)) {
                System.setProperty("gfAgentPropertyFile", value);
            }
            agentProps.setProperty(prop, value);
        }
        return options;
    }

    public void start(String[] args) throws Exception {
        Map<String, Object> options = this.getStartOptions(args);
        this.workingDirectory = IOUtils.tryGetCanonicalFileElseGetAbsoluteFile((File)options.get(DIR));
        this.verifyAndClearStatus();
        this.runCommandLine(options, this.buildCommandLine(options));
        this.pollAgentUntilRunning();
        ExitCode.NORMAL.doSystemExit();
    }

    private void verifyAndClearStatus() throws Exception {
        Status status = this.getStatus();
        if (status != null && status.state != 0) {
            throw new IllegalStateException("JMX Agent exists but was not shutdown.");
        }
        this.deleteStatus();
    }

    private String[] buildCommandLine(Map<String, Object> options) {
        List<String> commands = JavaCommandBuilder.buildCommand(AgentLauncher.class.getName(), (String)options.get(CLASSPATH), null, (List)options.get(VMARGS));
        commands.add("server");
        commands.add("-dir=" + this.workingDirectory);
        Properties agentProps = (Properties)options.get(AGENT_PROPS);
        for (Object key : agentProps.keySet()) {
            commands.add(key + "=" + agentProps.get(key.toString()));
        }
        return commands.toArray(new String[0]);
    }

    private void printCommandLine(String[] commandLine) {
        if (PRINT_LAUNCH_COMMAND) {
            System.out.print("Starting " + this.basename + " with command:\n");
            for (String command : commandLine) {
                System.out.print(command);
                System.out.print(' ');
            }
            System.out.println();
        }
    }

    private int runCommandLine(Map<String, Object> options, String[] commandLine) throws IOException {
        File startLogFile = IOUtils.tryGetCanonicalFileElseGetAbsoluteFile(new File(this.workingDirectory, this.startLogFileName));
        if (startLogFile.exists() && !startLogFile.delete()) {
            throw new IOException(String.format("Unable to delete file %s.", startLogFile.getAbsolutePath()));
        }
        HashMap<String, String> env = new HashMap<String, String>();
        SocketCreator.readSSLProperties(env, true);
        this.printCommandLine(commandLine);
        int pid = OSProcess.bgexec((String[])commandLine, (File)this.workingDirectory, (File)startLogFile, (boolean)false, env);
        System.out.println(String.format("Starting JMX Agent with pid: %s", pid));
        return pid;
    }

    private void pollAgentUntilRunning() throws Exception {
        Status status = this.spinReadStatus();
        while (status != null && status.state == 1) {
            Thread.sleep(500L);
            status = this.spinReadStatus();
        }
        if (status == null) {
            throw new Exception("No available status.");
        }
        System.out.println(status);
    }

    public void server(String[] args) throws Exception {
        Map<String, Object> options = this.getStartOptions(args);
        this.workingDirectory = IOUtils.tryGetCanonicalFileElseGetAbsoluteFile((File)options.get(DIR));
        this.writeStatus(AgentLauncher.createStatus(this.basename, 1, OSProcess.getId()));
        Agent agent = this.createAgent((Properties)options.get(AGENT_PROPS));
        Thread thread = this.createAgentProcessThread(agent);
        thread.start();
        this.pollAgentForPendingShutdown(agent);
    }

    private Agent createAgent(Properties props) throws IOException, AdminException {
        ClusterDistributionManager.setIsDedicatedAdminVM(true);
        SystemFailure.setExitOK(true);
        AgentConfigImpl config = new AgentConfigImpl(props);
        if (config.getLogFile() == null || "".equals(config.getLogFile().trim())) {
            config.setLogFile("agent.log");
        }
        OSProcess.redirectOutput((File)new File(config.getLogFile()));
        return AgentFactory.getAgent(config);
    }

    private Thread.UncaughtExceptionHandler createUncaughtExceptionHandler() {
        return (t, e) -> {
            if (e instanceof VirtualMachineError) {
                SystemFailure.setFailure((VirtualMachineError)e);
            }
            this.setServerError(String.format("Uncaught exception in thread %s", t.getName()), e);
        };
    }

    private Thread createAgentProcessThread(Agent agent) {
        LoggingThread thread = new LoggingThread("Start agent", this.createAgentProcessRunnable(agent));
        thread.setUncaughtExceptionHandler(this.createUncaughtExceptionHandler());
        return thread;
    }

    private Runnable createAgentProcessRunnable(final Agent agent) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    agent.start();
                    AgentLauncher.this.writeStatus(AgentLauncher.createStatus(AgentLauncher.this.basename, 2, OSProcess.getId()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (GemFireException e) {
                    e.printStackTrace();
                    this.handleGemFireException(e);
                }
            }

            private void handleGemFireException(GemFireException e) {
                String message = String.format("Server failed to start: %s", e.getMessage());
                if (e.getCause() != null && e.getCause().getCause() != null) {
                    message = message + ", " + e.getCause().getCause().getMessage();
                }
                AgentLauncher.this.setServerError(null, new Exception(message));
            }
        };
    }

    private void setServerError(String message, Throwable cause) {
        try {
            this.writeStatus(AgentLauncher.createStatus(this.basename, 4, OSProcess.getId(), message, cause));
        }
        catch (Exception e) {
            logger.fatal(e.getMessage(), (Throwable)e);
            ExitCode.FATAL.doSystemExit();
        }
    }

    private void pollAgentForPendingShutdown(Agent agent) throws Exception {
        while (true) {
            AgentLauncher.pause(500);
            this.spinReadStatus();
            if (!this.isStatus(3, 4)) continue;
            agent.stop();
            ExitCode exitCode = this.isStatus(4) ? ExitCode.FATAL : ExitCode.NORMAL;
            this.writeStatus(AgentLauncher.createStatus(this.status, 0));
            exitCode.doSystemExit();
        }
    }

    protected Map<String, Object> getStopOptions(String[] args) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put(DIR, IOUtils.tryGetCanonicalFileElseGetAbsoluteFile(new File(".")));
        for (String arg : args) {
            if (arg.equals("stop") || arg.equals("status")) continue;
            if (arg.startsWith("-dir=")) {
                AgentLauncher.processDirOption(options, arg.substring("-dir=".length()));
                continue;
            }
            throw new Exception(String.format("Unknown argument: %s", arg));
        }
        return options;
    }

    public void stop(String[] args) throws Exception {
        Map<String, Object> options = this.getStopOptions(args);
        this.workingDirectory = IOUtils.tryGetCanonicalFileElseGetAbsoluteFile((File)options.get(DIR));
        ExitCode exitCode = ExitCode.FATAL;
        if (new File(this.workingDirectory, this.statusFileName).exists()) {
            this.spinReadStatus();
            if (!this.isStatus(0)) {
                this.writeStatus(AgentLauncher.createStatus(this.basename, 3, this.status.pid));
            }
            this.pollAgentForShutdown();
            if (this.isStatus(0)) {
                System.out.println(String.format("The %s has shut down.", this.basename));
                this.deleteStatus();
                exitCode = ExitCode.NORMAL;
            } else {
                System.out.println(String.format("Timeout waiting for %s to shutdown, status is: %s", this.basename, this.status));
            }
        } else {
            System.out.println(String.format("The specified working directory (%s) contains no status file", this.workingDirectory));
        }
        exitCode.doSystemExit();
    }

    private void pollAgentForShutdown() throws InterruptedException {
        long endTime = System.currentTimeMillis() + 20000L;
        long clock = 0L;
        while (clock < endTime && !this.isStatus(0)) {
            AgentLauncher.pause(500);
            this.spinReadStatus();
            clock = System.currentTimeMillis();
        }
    }

    public void status(String[] args) throws Exception {
        this.workingDirectory = IOUtils.tryGetCanonicalFileElseGetAbsoluteFile((File)this.getStopOptions(args).get(DIR));
        System.out.println(this.getStatus());
        ExitCode.NORMAL.doSystemExit();
    }

    protected Status getStatus() throws Exception {
        Status status = new File(this.workingDirectory, this.statusFileName).exists() ? this.spinReadStatus() : AgentLauncher.createStatus(this.basename, 0, 0, String.format("%s is not running in the specified working directory: (%s).", this.basename, this.workingDirectory), null);
        return status;
    }

    private boolean isStatus(Integer ... states2) {
        return this.status != null && Arrays.asList(AgentLauncher.defaultToUnknownStateIfNull(states2)).contains(this.status.state);
    }

    protected void deleteStatus() throws IOException {
        this.deleteStatus(this.workingDirectory);
    }

    void deleteStatus(File workingDirectory) throws IOException {
        File statusFile = new File(workingDirectory, this.statusFileName);
        if (statusFile.exists() && !statusFile.delete()) {
            throw new IOException("Could not delete status file (" + statusFile.getAbsolutePath() + ")");
        }
    }

    protected Status readStatus() throws IOException {
        return this.readStatus(this.workingDirectory);
    }

    Status readStatus(File workingDirectory) throws IOException {
        Status status;
        FileInputStream fileIn = null;
        ObjectInputStream objectIn = null;
        try {
            fileIn = new FileInputStream(new File(workingDirectory, this.statusFileName));
            objectIn = new ObjectInputStream(fileIn);
            status = this.status = (Status)objectIn.readObject();
        }
        catch (ClassNotFoundException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.close(objectIn);
                IOUtils.close(fileIn);
                throw throwable;
            }
        }
        IOUtils.close(objectIn);
        IOUtils.close(fileIn);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Status spinReadStatus() {
        Status status = null;
        long endTime = System.currentTimeMillis() + 20000L;
        long clock = 0L;
        while (status == null && clock < endTime) {
            try {
                status = this.readStatus();
            }
            catch (Exception ignore) {
                AgentLauncher.pause(500);
            }
            finally {
                clock = System.currentTimeMillis();
            }
        }
        return status;
    }

    public Status writeStatus(Status status) throws IOException {
        return this.writeStatus(status, this.workingDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Status writeStatus(Status status, File workingDirectory) throws IOException {
        Status status2;
        FileOutputStream fileOut = null;
        ObjectOutputStream objectOut = null;
        try {
            fileOut = new FileOutputStream(new File(workingDirectory, this.statusFileName));
            objectOut = new ObjectOutputStream(fileOut);
            objectOut.writeObject(status);
            objectOut.flush();
            status2 = this.status = status;
        }
        catch (Throwable throwable) {
            IOUtils.close(objectOut);
            IOUtils.close(fileOut);
            throw throwable;
        }
        IOUtils.close(objectOut);
        IOUtils.close(fileOut);
        return status2;
    }

    protected static Status createStatus(String basename, int state, int pid) {
        return AgentLauncher.createStatus(basename, state, pid, null, null);
    }

    protected static Status createStatus(String basename, int state, int pid, String msg, Throwable t) {
        Status status = new Status(basename);
        status.state = state;
        status.pid = pid;
        status.msg = msg;
        status.exception = t;
        return status;
    }

    protected static Status createStatus(Status status, int state) {
        assert (status != null) : "The status to clone cannot be null!";
        return AgentLauncher.createStatus(status.baseName, state, status.pid, status.msg, status.exception);
    }

    protected static Integer[] defaultToUnknownStateIfNull(Integer ... states2) {
        Integer[] integerArray;
        if (states2 != null) {
            integerArray = states2;
        } else {
            Integer[] integerArray2 = new Integer[1];
            integerArray = integerArray2;
            integerArray2[0] = 6;
        }
        return integerArray;
    }

    protected static boolean pause(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    protected static File processDirOption(Map<String, Object> options, String dirValue) throws FileNotFoundException {
        File workingDirectory = new File(dirValue);
        if (!workingDirectory.exists()) {
            throw new FileNotFoundException(String.format("The input working directory does not exist: %s", dirValue));
        }
        options.put(DIR, workingDirectory);
        return workingDirectory;
    }

    private static void usage(String message) {
        PrintStream out = System.out;
        out.println("\n** " + message + "\n");
        out.println("agent start [-J<vmarg>]* [-dir=<dir>] [prop=value]*");
        out.println("Starts the GemFire JMX Agent");
        out.println("\t<vmarg> a VM-option passed to the agent's VM, example -J-Xmx1024M for a 1 Gb heap");
        out.println("\t<dir> Directory in which agent runs, default is the current directory");
        out.println("\t<prop> A configuration property/value passed to the agent");
        out.println("\t(see help config for more details)");
        out.println();
        out.println("agent stop [-dir=<dir>]");
        out.println("Stops a GemFire JMX Agent");
        out.println("\t<dir> Directory in which agent runs, default is the current directory");
        out.println();
        out.println("agent status [-dir=<dir>]");
        out.println("Reports the status and the process id of a GemFire JMX Agent");
        out.println("\t<dir> Directory in which agent runs, default is the current directory");
        out.println();
        ExitCode.FATAL.doSystemExit();
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            AgentLauncher.usage("Missing command");
        }
        SystemFailure.loadEmergencyClasses();
        AgentLauncher launcher = new AgentLauncher("Agent");
        try {
            String command = args[0];
            if (command.equalsIgnoreCase("start")) {
                launcher.start(args);
            } else if (command.equalsIgnoreCase("server")) {
                launcher.server(args);
            } else if (command.equalsIgnoreCase("stop")) {
                launcher.stop(args);
            } else if (command.equalsIgnoreCase("status")) {
                launcher.status(args);
            } else if (command.toLowerCase().matches("-{0,2}help")) {
                if (args.length > 1) {
                    String topic = args[1];
                    if (topic.equals("config")) {
                        launcher.configHelp();
                    } else {
                        AgentLauncher.usage(String.format("No help available for %s", topic));
                    }
                }
                AgentLauncher.usage("agent help");
            } else {
                AgentLauncher.usage(String.format("Unknown command: %s", command));
            }
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            t.printStackTrace();
            System.err.println(String.format("Error : %s", t.getLocalizedMessage()));
            ExitCode.FATAL.doSystemExit();
        }
    }

    static class Status
    implements Serializable {
        private static final long serialVersionUID = -7758402454664266174L;
        int pid = 0;
        int state = 0;
        final String baseName;
        String msg;
        Throwable exception;

        public Status(String baseName) {
            this.baseName = baseName;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            if (this.pid == Integer.MIN_VALUE && this.state == 0 && this.msg != null) {
                buffer.append(this.msg);
            } else {
                buffer.append(String.format("%s pid: %d status: ", this.baseName, this.pid));
                switch (this.state) {
                    case 0: {
                        buffer.append("shutdown");
                        break;
                    }
                    case 1: {
                        buffer.append("starting");
                        break;
                    }
                    case 2: {
                        buffer.append("running");
                        break;
                    }
                    case 3: {
                        buffer.append("shutdown pending");
                        break;
                    }
                    case 4: {
                        buffer.append("shutdown pending after failed startup");
                        break;
                    }
                    default: {
                        buffer.append("unknown");
                    }
                }
                if (this.exception != null) {
                    if (this.msg != null) {
                        buffer.append("\n").append(this.msg).append(" - ");
                    } else {
                        buffer.append("\n " + String.format("Exception in %s : %s ", this.baseName, this.exception.getMessage()) + " - ");
                    }
                    buffer.append("See log file for details.");
                }
            }
            return buffer.toString();
        }
    }
}

