/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.operations;

import org.apache.geode.annotations.Immutable;

@Immutable
public final class InterestType {
    public static final byte TP_KEY = 0;
    public static final byte TP_REGEX = 1;
    public static final byte TP_LIST = 4;
    @Immutable
    private static final InterestType[] VALUES = new InterestType[10];
    @Immutable
    public static final InterestType KEY = new InterestType("KEY", 0, 0);
    @Immutable
    public static final InterestType LIST = new InterestType("LIST", 4, 1);
    @Immutable
    public static final InterestType REGULAR_EXPRESSION = new InterestType("REGULAR_EXPRESSION", 1, 3);
    private final String name;
    private final byte ordinal;
    private final byte interestType;

    private InterestType(String name, byte interestType2, int ordinal) {
        this.name = name;
        this.interestType = interestType2;
        this.ordinal = (byte)ordinal;
        InterestType.VALUES[this.ordinal] = this;
    }

    public boolean isKey() {
        return this.interestType == 0;
    }

    public boolean isList() {
        return this.interestType == 4;
    }

    public boolean isRegularExpression() {
        return this.interestType == 1;
    }

    public static InterestType fromOrdinal(byte ordinal) {
        return VALUES[ordinal];
    }

    public byte toOrdinal() {
        return this.ordinal;
    }

    public String toString() {
        return this.name;
    }
}

